/**
 * *##% guix-compiler-gwt
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.generator;

//~--- non-JDK imports --------------------------------------------------------

import org.nuiton.guix.model.GuixModelObject;

//~--- JDK imports ------------------------------------------------------------

import java.lang.reflect.Modifier;
import java.util.Map;

/**
 * Generates an implementation class
 *
 * @author morin
 */
public class GwtImplementationGenerator extends GwtJavaFileGenerator {

    /**
     * Constructor
     *
     * @param gmo GuixModelObject representing the class to generate
     * @param classes List of the classes to generate
     */
    public GwtImplementationGenerator(GuixModelObject gmo, Map<String, JavaFile> classes) {
        super(gmo, classes);
        jf = new JavaFile(Modifier.PUBLIC,
                JavaFile.CLASS,
                gmo.getClassDescriptor().getPackageName(),
                gmo.getClassDescriptor().getName() + "Impl",
                gmo.getClassDescriptor().getName() + "Abstract",
                gmo.getJavadoc());
    }

    @Override
    public JavaFile generate() {
        super.addImports();
        jf.addMethod(new JavaMethod(Modifier.PUBLIC, null, gmo.getClassDescriptor().getName() + "Impl",
                null, null, "super();", "Constructor"));
        return jf;
    }

    public void addMainMethod() {
        jf.addMethod(new JavaMethod(
                Modifier.PUBLIC,
                "void",
                "onModuleLoad",
                null,
                null,
                "com.google.gwt.user.client.ui.RootPanel.get().add(this);",
                null));
        jf.addInterface("com.google.gwt.core.client.EntryPoint");
    }

}

