/*
 * Decompiled with CFR 0.152.
 */
package com.acme;

import com.acme.ChatFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.util.ajax.AjaxFilter;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

/*
 * Exception performing whole class analysis ignored.
 */
public class ChatFilter
extends AjaxFilter {
    private Map chatrooms;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.chatrooms = new HashMap();
    }

    public void destroy() {
        super.destroy();
        this.chatrooms.clear();
        this.chatrooms = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session = ((HttpServletRequest)request).getSession(true);
        super.doFilter(request, response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String method, String message, HttpServletRequest request, AjaxFilter.AjaxResponse response) {
        request.getSession(true);
        String roomName = request.getParameter("room");
        if (roomName == null) {
            roomName = "0";
        }
        HashMap room = null;
        ChatFilter chatFilter = this;
        synchronized (chatFilter) {
            room = (HashMap)this.chatrooms.get(roomName);
            if (room == null) {
                room = new HashMap();
                this.chatrooms.put(roomName, room);
            }
        }
        if ("join".equals(method)) {
            this.doJoinChat(room, message, request, response);
        } else if ("chat".equals(method)) {
            this.doChat(room, message, request, response);
        } else if ("poll".equals(method)) {
            this.doPoll(room, request, response);
        } else if ("leave".equals(method)) {
            this.doLeaveChat(room, message, request, response);
        } else {
            super.handle(method, message, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJoinChat(Map room, String name, HttpServletRequest request, AjaxFilter.AjaxResponse response) {
        HttpSession session = request.getSession(true);
        String id = session.getId();
        if (name == null || name.length() == 0) {
            name = "Newbie";
        }
        Member member = null;
        Map map = room;
        synchronized (map) {
            member = (Member)room.get(id);
            if (member == null) {
                member = new Member(this, session, name);
                room.put(session.getId(), member);
            } else {
                member.setName(name);
            }
            this.sendMessage(room, member, "has joined the chat", true);
            this.sendMembers(room, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLeaveChat(Map room, String name, HttpServletRequest request, AjaxFilter.AjaxResponse response) {
        HttpSession session = request.getSession(true);
        String id = session.getId();
        Member member = null;
        Map map = room;
        synchronized (map) {
            member = (Member)room.get(id);
            if (member == null) {
                return;
            }
            if ("Elvis".equals(member.getName())) {
                this.sendMessage(room, member, "has left the building", true);
            } else {
                this.sendMessage(room, member, "has left the chat", true);
            }
            room.remove(id);
            member.setName(null);
        }
        this.sendMembers(room, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChat(Map room, String text, HttpServletRequest request, AjaxFilter.AjaxResponse response) {
        HttpSession session = request.getSession(true);
        String id = session.getId();
        Member member = null;
        Map map = room;
        synchronized (map) {
            member = (Member)room.get(id);
            if (member == null) {
                return;
            }
            this.sendMessage(room, member, text, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPoll(Map room, HttpServletRequest request, AjaxFilter.AjaxResponse response) {
        HttpSession session = request.getSession(true);
        String id = session.getId();
        long timeoutMS = 60000L;
        if (request.getParameter("timeout") != null) {
            timeoutMS = Long.parseLong(request.getParameter("timeout"));
        }
        if (session.isNew()) {
            timeoutMS = 1L;
        }
        Member member = null;
        Map map = room;
        synchronized (map) {
            member = (Member)room.get(id);
            if (member == null) {
                member = new Member(this, session, null);
                room.put(session.getId(), member);
            }
            Continuation continuation = ContinuationSupport.getContinuation((HttpServletRequest)request, (Object)room);
            if (!member.hasMessages()) {
                if (member.getContinuation() != null && member.getContinuation() != continuation) {
                    Message duplicate = new Message("System", "Multiple frames/tabs/windows from same browser!", true);
                    Message action = new Message("System", "Please use only one frame/tab/window", true);
                    member.addMessage(duplicate);
                    member.addMessage(action);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {}
                } else {
                    member.setContinuation(continuation);
                    continuation.suspend(timeoutMS);
                }
            }
            if (member.getContinuation() == continuation) {
                member.setContinuation(null);
            }
            if (member.sendMessages(response)) {
                this.sendMembers(room, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(Map room, Member member, String text, boolean alert) {
        Message event = new Message(member.getName(), text, alert);
        ArrayList<Member> invalids = null;
        Map map = room;
        synchronized (map) {
            Iterator iter = room.values().iterator();
            while (iter.hasNext()) {
                Member m = (Member)iter.next();
                try {
                    m.getSession().getAttribute("anything");
                    m.addMessage(event);
                }
                catch (IllegalStateException e) {
                    if (invalids == null) {
                        invalids = new ArrayList<Member>();
                    }
                    invalids.add(m);
                    iter.remove();
                }
            }
        }
        for (int i = 0; invalids != null && i < invalids.size(); ++i) {
            Member m = (Member)invalids.get(i);
            this.sendMessage(room, m, "has timed out of the chat", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMembers(Map room, AjaxFilter.AjaxResponse response) {
        StringBuffer buf = new StringBuffer();
        buf.append("<ul>\n");
        Map map = room;
        synchronized (map) {
            Iterator iter = room.values().iterator();
            while (iter.hasNext()) {
                Member m = (Member)iter.next();
                if (m.getName() == null) continue;
                buf.append("<li>");
                buf.append(ChatFilter.encodeText((String)m.getName()));
                buf.append("</li>\n");
            }
        }
        buf.append("</ul>\n");
        response.elementResponse("members", buf.toString());
    }

    static /* synthetic */ void access$000(ChatFilter x0, Map x1, Member x2, String x3, boolean x4) {
        x0.sendMessage(x1, x2, x3, x4);
    }
}

