/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.admin.helpers;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiExtensionsListener;
import org.chorem.vradi.ui.admin.helpers.AdminBeanConstant;
import org.chorem.vradi.ui.admin.helpers.AdminNavigationTreeHelper;
import org.chorem.vradi.ui.admin.loadors.FormTypeNodeLoadors;
import org.chorem.vradi.ui.tree.VradiDataProvider;
import org.chorem.vradi.ui.tree.VradiTreeNode;
import org.nuiton.wikitty.entities.WikittyExtension;

public class FormTypeNavigationTreeHelper
extends AdminNavigationTreeHelper
implements VradiExtensionsListener {
    private static final Log log = LogFactory.getLog(FormTypeNavigationTreeHelper.class);

    public FormTypeNavigationTreeHelper(VradiDataProvider dataProvider) {
        super(dataProvider);
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    @Override
    public VradiTreeNode createNode() {
        return new VradiTreeNode(String.class, AdminBeanConstant.FORM_TYPE.getCategoryName(), null, new FormTypeNodeLoadors());
    }

    @Override
    public void createEntityNode(String name) {
        this.createFormTypeNode(name, false);
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        for (WikittyExtension ext : added) {
            VradiTreeNode existingNode;
            String name = ext.getName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("search node with name " + name));
            }
            if ((existingNode = this.findNode(this.getRootNode(), name)) != null) {
                this.refresh(existingNode);
                continue;
            }
            this.createEntityNode(name);
        }
    }

    @Override
    public void extensionsRemoved(Set<String> removedName) {
        this.removeEntities(removedName);
    }
}

