/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiDataProvider.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/tree/VradiDataProvider.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.tree;

import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.services.VradiDataService;
import org.chorem.vradi.services.VradiService;
import org.nuiton.wikitty.WikittyProxy;

/**
 * Provider de données pour les noeuds des arbres.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class VradiDataProvider implements NavDataProvider {

    /** Logger */
    static private final Log log = LogFactory.getLog(VradiDataProvider.class);

    /** Wikitty proxy. */
    protected WikittyProxy proxy;

    /** Vradi data service. */
    protected VradiDataService dataService;

    public VradiDataProvider() {
        proxy = VradiService.getWikittyProxy();
        dataService = VradiService.getVradiDataService();
    }

    /**
     * Get wikitty proxy.
     *
     * @return
     */
    public WikittyProxy getWikittyProxy() {
        return proxy;
    }

    /**
     * Get vradi data service.
     *
     * @return
     */
    public VradiDataService getVradiDataService() {
        return dataService;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}
