/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: NumberListCellRenderer.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/renderers/NumberListCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.renderers;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import java.awt.Component;

import static org.nuiton.i18n.I18n._;

/**
 * NumberListCellRenderer.
 * <p/>
 * Display a special string for "-1" value;
 *
 * @author schorlet
 * @version $Revision: 21 $ $Date: 2011-05-09 18:43:58 +0200 (lun., 09 mai 2011) $
 * @since 24 mars 2010 12:26:58
 */
public class NumberListCellRenderer extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getListCellRendererComponent(JList list, Object value,
                                                  int index, boolean isSelected, boolean cellHasFocus) {

        Number number = (Number) value;
        Object newValue = number;

        // -1 means no search restriction
        if (number.intValue() == -1) {
            newValue = _("vradi.common.alls");
        }

        return super.getListCellRendererComponent(list, newValue, index, isSelected,
                                                  cellHasFocus);
    }
}
