/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.offer.editors;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumEditor extends VradiEditor<Float, NumEditorModel> implements JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_EDITOR_MODEL = "editor.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVtqy1IpCJBghAUU9mGy5QxBFGyUFCTWE0Iuz3aEdsrszzszC1oPxT/BP0LsXE2+ejAfPHrwY/wVjPHg1vpltu1RXqbaH2Wbe+773vV/z8gvKSYHmD3AU2SIMFPWJvX5zd/e+c0Aa6jaRDUG5YgLFv0wWZeuo6PbupUKX61UNL3fg5TXmcxaQ4Bh6qYrGpGp7RLYIUQrN9iMaUpZrPfNSxEPRZe2JSmN9/u1r9pn79EUWoYiDOp3K3EmoJJORKspSV6EJiHSIyx4OmiBD0KAJekv6bs3DUm5inzxCT1ChivIcCyBT6NLgKRsOg4+4QqWFHYFdesel4LOo0HUmmnajxQTx7UNtsUNqs/19ImxifKS9GfqxO+eGJ69Qzmcu8RRa/Af0hoYkFNYh9qiLwQAi+mrWM9jyCGph1/S5071MGEpxiDUWKFOTCV2xqANa38LB8XD52Fmhq32xYufYpqU6RMRqNWyCQz8v9vnDpNjJpCStzNRRToRwrdB0/ffh2gZTPFbTv4yVJjTWH1OTH998fl3pzlIJYp9PdT22CtBjLhgnQlEdejwepFBRr7yB+VIdWZJ4sEdmT2ZShNU6ZhAH8c5puK3h9l0sW0CRK3x6+27q4YdTKFtBYx7DbgVr/3vIUi0BVWCeG/Ebq0bR6aNROM9qbVBwD7dZCG05swx9w3MODVyo9UoERZhJKUJPiWO9/z5Ze7XaLUQGhF34o3tSjNweytPAowExa9XZmNQ1KnJJQpclm5G2Kxn9neSdEZo153xapkUfR9QP/Rp9bAIsRKH+XDHa9b9rA1NZOFRsi/GQ/4VoagCiEYfgYEiOAgmw4xF3SJqiT4MByjMIVfzsDEliGZIHbT6smtHO6rXh6VmOJ28OK3i/nVCRlf/nHYetOjJDcAv2hw3bRkvTbRNJ1LD5hpJU4AkYlqcAPDXaPCmvn0Mz1N8bCAAA";
    private static final Log log = LogFactory.getLog(NumEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "value",  editorName = "editor")
    protected NumberEditor editor;
    protected NumEditorModel model;
    @Validator( validatorId = "validator")
    protected SwingValidator<NumEditorModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private NumEditor $VradiEditor0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void init() {
        super.init();
        editor.init();
    }
    
    void registerValidator() {
        validator.setBean(model);
        getContextValue(jaxx.runtime.validator.swing.SwingValidatorMessageTableModel.class,"errorEditorTable")
                .registerValidator(validator);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NumEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public NumEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NumEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public NumEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NumEditor() {
        $initialize();
    }

    public NumEditor(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor getEditor() {
        return editor;
    }

    public NumEditorModel getModel() {
        return model;
    }

    public SwingValidator<NumEditorModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(NumEditorModel model) {
        NumEditorModel oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorContent() {
        if (!allComponentsCreated) {
            return;
        }
        editorContent.add(SwingUtil.boxComponentWithJxLayer(editor), BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new NumberEditor());
        
        editor.setName("editor");
        editor.setProperty("value");
    }

    @Override
    protected void createEditorContent() {
        super.createEditorContent();
        editorContent.setName("editorContent");
        editorContent.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new NumEditorModel());
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(NumEditorModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToValidator();
        addChildrenToEditorContent();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 10 property setters
        editorContent.setMaximumSize(new Dimension(0, 28));
        editor.setAutoPopup(true);
        editor.setBean(model);
        editor.setMinimumSize(new Dimension(0,28));
        editor.setModelType(Float.class);
        editor.setShowPopupButton(true);
        editor.setShowReset(true);
        editor.setUseFloat(true);
        editor.setUseSign(false);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$VradiEditor0", $VradiEditor0);
        createModel();
        createValidator();
        createEditor();
        // inline creation of $VradiEditor0
        setName("$VradiEditor0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDITOR_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("value", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editor.setModel(model.getValue());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("value", this);
                }
            }
        });
    }

}