/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: FormMenu.java 21 2011-05-09 16:43:58Z sletellier $
 * $HeadURL: http://svn.chorem.org/svn/vradi/tags/vradi-0.6/vradi-swing/src/main/java/org/chorem/vradi/ui/models/FormMenu.java $
 * %%
 * Copyright (C) 2009 - 2010 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.models;

import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiExtensionsListener;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.VradiMainUIHandler;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.nuiton.wikitty.entities.WikittyExtension;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import static org.nuiton.i18n.I18n._;

/** @author letellier */
public class FormMenu extends JMenu implements VradiExtensionsListener {

    /** Logger */
    private static final Log log = LogFactory.getLog(FormMenu.class);

    protected VradiMainUIHandler handler;

    protected List<JMenuItem> items = new ArrayList<JMenuItem>();

    public FormMenu(VradiMainUIHandler handler) {
        this.handler = handler;
        updateMenus();

        // register each tree on wikitty service
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    protected void updateMenus() {
        for (JMenuItem item : items) {
            remove(item);
        }
        List<WikittyExtension> forms = null;
        try {
            forms = VradiService.getVradiDataService().getAllFormTypes();
        } catch (VradiException eee) {
            log.error("cant get all forms type", eee);
            ErrorDialogUI.showError(eee);
        }
        Collections.sort(forms, VradiComparators.EXTENSION_COMPARATOR);
        for (final WikittyExtension form : forms) {
            JMenuItem item = new JMenuItem(_("vradi.menu.form.new", form.getName()));
            item.addActionListener(new ActionListener() {

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    handler.createForm(form);
                }
            });

            items.add(item);
            add(item);
        }
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        updateMenus();
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        updateMenus();
    }
}
