/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiConstants;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.services.VradiStorageService;
import org.chorem.vradi.ui.admin.AdminHandler;
import org.chorem.vradi.ui.helpers.UIHelper;
import static org.nuiton.i18n.I18n._;

public class XmlStreamConfigUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ASSIGN_AUTO_SELECTED = "assignAuto.selected";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(XmlStreamConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JCheckBox assignAuto;
    protected XmlStream bean;
    protected JComboBox hourDays;
    protected JComboBox minuteDays;
    protected XmlStreamConfigUI xmlStreamConfigUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ComboBoxModel minutesModel;
    protected ComboBoxModel hoursModel;
    protected ComboBoxModel daysModel;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getBean() != null) {
                
    
                    // Parse la valeur ImportTime du bean XmlStream courant et
                    // initialise correctement les differents panel.
                    //
                    // Dans le cas ou le pattern ne match pas, la valeur par defaut
                    // est celle des services (à savoir, tous les 1 jour, à minuit).
                    //
                    String xmlStringImportTime = bean.getImportTime();
    
                    if (xmlStringImportTime != null && !xmlStringImportTime.isEmpty()) {
                        Matcher matcher = VradiConstants.XML_STREAM_IMPORT_TIME.matcher(xmlStringImportTime);
            
                        if (matcher.find()) {
                            // selection des heures
                            hourDays.setSelectedItem(Integer.valueOf(matcher.group(1)));
                            // selection de la minutes
                            minuteDays.setSelectedItem(Integer.valueOf(matcher.group(2)));
                        }
                    }
                } else {
                    // clear UI
                    hourDays.setSelectedItem(0);
                    minuteDays.setSelectedItem(0);
                    assignAuto.setSelected(false);
                }
            }
        });
    }
    
    /**
     * Set import time value into bean.
     */
    protected void setImportTimeValue() {
        if (bean != null) {
            String importTime = null;
            importTime = hourDays.getSelectedItem().toString() + ":" + minuteDays.getSelectedItem().toString();
            bean.setImportTime(importTime);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public XmlStreamConfigUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public XmlStreamConfigUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public XmlStreamConfigUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public XmlStreamConfigUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public XmlStreamConfigUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public XmlStreamConfigUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public XmlStreamConfigUI() {
        $initialize();
    }

    public XmlStreamConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__assignAuto(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setAutoAssign(assignAuto.isSelected());
    }

    public void doActionPerformed__on__hourDays(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setImportTimeValue();
    }

    public void doActionPerformed__on__minuteDays(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setImportTimeValue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JCheckBox getAssignAuto() {
        return assignAuto;
    }

    public XmlStream getBean() {
        return bean;
    }

    public JComboBox getHourDays() {
        return hourDays;
    }

    public JComboBox getMinuteDays() {
        return minuteDays;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(XmlStream bean) {
        XmlStream oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToXmlStreamConfigUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0);
        add(hourDays);
        add($JLabel1);
        add(minuteDays);
        add(assignAuto);
    }

    protected void createAssignAuto() {
        $objectMap.put("assignAuto", assignAuto = new JCheckBox());
        
        assignAuto.setName("assignAuto");
        assignAuto.setText(_("vradi.adminXmlStream.assignAuto"));
        assignAuto.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__assignAuto"));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createHourDays() {
        $objectMap.put("hourDays", hourDays = new JComboBox());
        
        hourDays.setName("hourDays");
        hourDays.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hourDays"));
    }

    protected void createMinuteDays() {
        $objectMap.put("minuteDays", minuteDays = new JComboBox());
        
        minuteDays.setName("minuteDays");
        minuteDays.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__minuteDays"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToXmlStreamConfigUI();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        hourDays.setModel(UIHelper.getHourModel());
        hourDays.setRenderer(UIHelper.get2DigitsRenderer());
        hourDays.setSelectedItem(0);
        minuteDays.setModel(UIHelper.getMinuteModel());
        minuteDays.setRenderer(UIHelper.get2DigitsRenderer());
        minuteDays.setSelectedItem(0);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("xmlStreamConfigUI", xmlStreamConfigUI);
        createBean();
        minutesModel = new DefaultComboBoxModel(new Object[]{15, 30, 45});
        hoursModel = UIHelper.getNumberComboBoxModel(1, 24);
        daysModel = UIHelper.getNumberComboBoxModel(1, 31);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.config.load"));
        createHourDays();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.common.timeseparator"));
        createMinuteDays();
        createAssignAuto();
        // inline creation of xmlStreamConfigUI
        setName("xmlStreamConfigUI");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ASSIGN_AUTO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("autoAssign", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    assignAuto.setSelected(getBean().getAutoAssign());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("autoAssign", this);
                }
            }
        });
    }

}