/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.vradi.ui.admin.content;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.ui.admin.AdminHandler;
import static org.nuiton.i18n.I18n._;

public class StatusEditionUI extends Table implements JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_WIKITTY = "wikitty";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESC_FIELD_BACKGROUND = "descField.background";
    public static final String BINDING_DESC_FIELD_EDITABLE = "descField.editable";
    public static final String BINDING_DESC_FIELD_TEXT = "descField.text";
    public static final String BINDING_NAME_FIELD_BACKGROUND = "nameField.background";
    public static final String BINDING_NAME_FIELD_EDITABLE = "nameField.editable";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_REMOVE_VISIBLE = "remove.visible";
    public static final String BINDING_VALIDATOR_BEAN = "validator.bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(StatusEditionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Status bean;
    protected JTextArea descField;
    protected JButton down;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JButton remove;
    protected StatusEditionUI statusEditionUI = this;
    protected JButton up;
    @Validator( validatorId = "validator")
    protected SwingValidator<Status> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected Status wikitty;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel contentPane;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public void setContentPane(JPanel contentPane){
        this.contentPane = contentPane;
    }
    
    void $afterCompleteSetup() {
    }
    
    protected AdminStatusUI getAdminStatusUI() {
        return getParentContainer(AdminStatusUI.class);
    }
    
    public void confirmDeletion() {
        int confirm = JOptionPane.showConfirmDialog(this,
                _("vradi.admin.confirmDelete", VradiHelper.getEntityName(bean)),
                _("vradi.admin.deleteTitle"), JOptionPane.YES_NO_OPTION);
    
        if (confirm == JOptionPane.YES_OPTION) {
            getAdminStatusUI().delete(this);
        }
    }
    
    public void up() {
         getAdminStatusUI().up(this);
    }
    
    public void down() {
         getAdminStatusUI().down(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StatusEditionUI() {
        $initialize();
    }

    public StatusEditionUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__down(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        down();
    }

    public void doActionPerformed__on__remove(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        confirmDeletion();
    }

    public void doActionPerformed__on__up(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        up();
    }

    public void doKeyReleased__on__descField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setDescription(descField.getText());
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        bean.setName(nameField.getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Status getBean() {
        return bean;
    }

    public JTextArea getDescField() {
        return descField;
    }

    public JButton getDown() {
        return down;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JButton getRemove() {
        return remove;
    }

    public JButton getUp() {
        return up;
    }

    public SwingValidator<Status> getValidator() {
        return validator;
    }

    public Status getWikitty() {
        return wikitty;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(Status bean) {
        Status oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setWikitty(Status wikitty) {
        Status oldValue = this.wikitty;
        this.wikitty = wikitty;
        firePropertyChange(PROPERTY_WIKITTY, oldValue, wikitty);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToStatusEditionUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(descField, new GridBagConstraints(3, 0, 1, 1, 0.7, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        add(up, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(down, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add(remove, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createDescField() {
        $objectMap.put("descField", descField = new JTextArea());
        
        descField.setName("descField");
        descField.setColumns(15);
        descField.setLineWrap(true);
        descField.setWrapStyleWord(true);
        descField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__descField"));
    }

    protected void createDown() {
        $objectMap.put("down", down = new JButton());
        
        down.setName("down");
        down.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__down"));
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.setColumns(20);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
    }

    protected void createRemove() {
        $objectMap.put("remove", remove = new JButton());
        
        remove.setName("remove");
        remove.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__remove"));
    }

    protected void createUp() {
        $objectMap.put("up", up = new JButton());
        
        up.setName("up");
        up.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__up"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidatorUtil.newValidator(Status.class, null));
    }

    protected void createWikitty() {
        $objectMap.put("wikitty", wikitty = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToStatusEditionUI();
        addChildrenToValidator();
        
        // apply 8 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        up.setIcon(SwingUtil.getUIManagerActionIcon("arrowUp"));
        down.setIcon(SwingUtil.getUIManagerActionIcon("arrowDown"));
        remove.setIcon(SwingUtil.getUIManagerActionIcon("delete"));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("statusEditionUI", statusEditionUI);
        createBean();
        createWikitty();
        createValidator();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminStatus.name"));
        createNameField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.adminStatus.desc"));
        createDescField();
        createUp();
        createDown();
        createRemove();
        // inline creation of statusEditionUI
        setName("statusEditionUI");
        
        // registers 8 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 8 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VALIDATOR_BEAN, true ,"bean") {
        
            @Override
            public void processDataBinding() {
                validator.setBean(getBean());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_BACKGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    nameField.setBackground(getBean().getModifiable() ? null : new Color(230, 230, 240));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    nameField.setEditable(getBean().getModifiable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(nameField, _(getBean().getName()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_BACKGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    descField.setBackground(getBean().getModifiable() ? null : new Color(230, 230, 240));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    descField.setEditable(getBean().getModifiable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    SwingUtil.setText(descField, _(getBean().getDescription()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().addPropertyChangeListener("modifiable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getBean() != null) {
                    remove.setVisible(getBean().getModifiable());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("bean", this);
                if (getBean() != null) {
                    getBean().removePropertyChangeListener("modifiable", this);
                }
            }
        });
    }

}