/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.apache.log4j.PropertyConfigurator;
import org.webharvest.definition.DefinitionResolver;
import org.webharvest.definition.ScraperConfiguration;
import org.webharvest.exception.PluginException;
import org.webharvest.gui.Ide;
import org.webharvest.runtime.Scraper;
import org.webharvest.utils.CommonUtil;

public class CommandLine {
    private static Map getArgValue(String[] args, boolean caseSensitive) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            String curr = args[i];
            String argName = caseSensitive ? curr : curr.toLowerCase();
            String argValue = "";
            int eqIndex = curr.indexOf(61);
            if (eqIndex >= 0) {
                argName = curr.substring(0, eqIndex).trim();
                argValue = curr.substring(eqIndex + 1).trim();
            }
            params.put(caseSensitive ? argName : argName.toLowerCase(), argValue);
        }
        return params;
    }

    private static Map getArgValue(String[] args) {
        return CommandLine.getArgValue(args, false);
    }

    public static void main(String[] args) throws IOException {
        Map params = CommandLine.getArgValue(args);
        if (params.size() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new Ide().createAndShowGUI();
                }
            });
        } else if (params.containsKey("-h") || params.containsKey("/h")) {
            CommandLine.printHelp();
            System.exit(0);
        } else {
            String proxyUser;
            String proxyHost;
            String logLevel;
            String workingDir;
            String configFilePath = (String)params.get("config");
            if (configFilePath == null || "".equals(configFilePath)) {
                System.err.println("You must specify configuration file path using config=<path> argument!");
                CommandLine.printHelp();
                System.exit(1);
            }
            if ((workingDir = (String)params.get("workdir")) == null || "".equals(workingDir)) {
                workingDir = ".";
            }
            if ((logLevel = (String)params.get("loglevel")) == null || "".equals(logLevel)) {
                logLevel = "INFO";
            }
            Properties props = new Properties();
            String logPropsFile = (String)params.get("logpropsfile");
            if (logPropsFile != null && !"".equals(logPropsFile)) {
                FileInputStream fis = new FileInputStream(new File(logPropsFile));
                props.load(fis);
                fis.close();
            } else {
                props.setProperty("log4j.rootLogger", logLevel.toUpperCase() + ", stdout");
                props.setProperty("log4j.appender.stdout", "org.apache.log4j.ConsoleAppender");
                props.setProperty("log4j.appender.stdout.layout", "org.apache.log4j.PatternLayout");
                props.setProperty("log4j.appender.stdout.layout.ConversionPattern", "%-5p (%20F:%-3L) - %m\n");
                props.setProperty("log4j.appender.file", "org.apache.log4j.DailyRollingFileAppender");
                props.setProperty("log4j.appender.file.File", workingDir + "/out.log");
                props.setProperty("log4j.appender.file.DatePattern", "yyyy-MM-dd");
                props.setProperty("log4j.appender.file.layout", "org.apache.log4j.PatternLayout");
                props.setProperty("log4j.appender.file.layout.ConversionPattern", "%-5p (%20F:%-3L) - %m\n");
            }
            PropertyConfigurator.configure((Properties)props);
            String pluginsString = (String)params.get("plugins");
            if (!CommonUtil.isEmpty(pluginsString)) {
                String[] plugins = CommonUtil.tokenize(pluginsString, ",");
                for (int i = 0; i < plugins.length; ++i) {
                    try {
                        DefinitionResolver.registerPlugin(plugins[i]);
                        continue;
                    }
                    catch (PluginException e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
            ScraperConfiguration config = null;
            String configLowercase = configFilePath.toLowerCase();
            config = configLowercase.startsWith("http://") || configLowercase.startsWith("https://") ? new ScraperConfiguration(new URL(configFilePath)) : new ScraperConfiguration(configFilePath);
            Scraper scraper = new Scraper(config, workingDir);
            String isDebug = (String)params.get("debug");
            if (CommonUtil.isBooleanTrue(isDebug)) {
                scraper.setDebug(true);
            }
            if ((proxyHost = (String)params.get("proxyhost")) != null && !"".equals(proxyHost)) {
                String proxyPort = (String)params.get("proxyport");
                if (proxyPort != null && !"".equals(proxyPort)) {
                    int port = Integer.parseInt(proxyPort);
                    scraper.getHttpClientManager().setHttpProxy(proxyHost, port);
                } else {
                    scraper.getHttpClientManager().setHttpProxy(proxyHost);
                }
            }
            if ((proxyUser = (String)params.get("proxyuser")) != null && !"".equals(proxyUser)) {
                String proxyPassword = (String)params.get("proxypassword");
                String proxyNTHost = (String)params.get("proxynthost");
                String proxyNTDomain = (String)params.get("proxyntdomain");
                scraper.getHttpClientManager().setHttpProxyCredentials(proxyUser, proxyPassword, proxyNTHost, proxyNTDomain);
            }
            Map caseSensitiveParams = CommandLine.getArgValue(args, true);
            for (Map.Entry entry : caseSensitiveParams.entrySet()) {
                String varName;
                String key = (String)entry.getKey();
                if (!key.startsWith("#") || (varName = key.substring(1)).length() <= 0) continue;
                scraper.addVariableToContext(varName, entry.getValue());
            }
            scraper.execute();
        }
    }

    private static void printHelp() {
        System.out.println("");
        System.out.println("To open Web-Harvest GUI:");
        System.out.println("   java -jar webharvestXX.jar");
        System.out.println("or just double-click webharvestXX.jar from the file manager.");
        System.out.println("");
        System.out.println("Command line use:");
        System.out.println("   java -jar webharvestXX.jar [-h] config=<path> [workdir=<path>] [debug=yes|no]");
        System.out.println("             [proxyhost=<proxy server> [proxyport=<proxy server port>]]");
        System.out.println("             [proxyuser=<proxy username> [proxypassword=<proxy password>]]");
        System.out.println("             [proxynthost=<NT host name>]");
        System.out.println("             [proxyntdomain=<NT domain name>]");
        System.out.println("             [loglevel=<level>]");
        System.out.println("             [logpropsfile=<path>]");
        System.out.println("             [plugins=<list of plugin classes>]");
        System.out.println("             [#var1=<value1> [#var2=<value2>...]]");
        System.out.println("");
        System.out.println("   -h            - shows this help.");
        System.out.println("   config        - path or URL of configuration (URL must begin with \"http://\" or \"https://\").");
        System.out.println("   workdir       - path of the working directory (default is current directory).");
        System.out.println("   debug         - specify if Web-Harvest generates debugging output (default is no).");
        System.out.println("   proxyhost     - specify proxy server.");
        System.out.println("   proxyport     - specify port for proxy server.");
        System.out.println("   proxyuser     - specify proxy server username.");
        System.out.println("   proxypassword - specify proxy server password.");
        System.out.println("   proxynthost   - NTLM authentication scheme - the host the request is originating from.");
        System.out.println("   proxyntdomain - NTLM authentication scheme - the domain to authenticate within.");
        System.out.println("   loglevel      - specify level of logging for Log4J (trace,info,debug,warn,error,fatal).");
        System.out.println("   logpropsfile  - file path to custom Log4J properties. If specified, loglevel is ignored.");
        System.out.println("   plugins       - comma-separated list of full plugins' class names.");
        System.out.println("   #varN, valueN - specify initial variables of the Web-Harvest context. To be recognized, ");
        System.out.println("                   each variable name must have prefix #. ");
    }
}

