/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiExtensionsListener;
import org.chorem.vradi.VradiHelper;
import org.chorem.vradi.entities.Status;
import org.chorem.vradi.entities.XmlStream;
import org.chorem.vradi.services.VradiException;
import org.chorem.vradi.services.VradiService;
import org.chorem.vradi.ui.helpers.UIHelper;
import org.chorem.vradi.ui.helpers.VradiComparators;
import org.chorem.vradi.ui.models.FormMenu;
import org.chorem.vradi.ui.search.SearchUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

public class RequestFieldMenu
extends JMenu
implements VradiExtensionsListener {
    private static final Log log = LogFactory.getLog(FormMenu.class);
    public static final String FIELD_NAME_SUFFIX = ":\"\"";
    protected SearchUI searchUI;
    protected Map<String, JMenu> formTypesMenu;
    protected Map<String, JMenuItem> formTypesFieldMenu;

    public RequestFieldMenu(SearchUI searchUI) {
        super(I18n._((String)"vradi.request.keywords", (Object[])new Object[0]));
        this.searchUI = searchUI;
        this.fillInfogeneMenu();
        List<WikittyExtension> formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        }
        catch (VradiException eee) {
            log.error((Object)"cant get all forms type", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);
        this.formTypesMenu = new HashMap<String, JMenu>();
        this.formTypesFieldMenu = new HashMap<String, JMenuItem>();
        if (formTypes != null) {
            for (WikittyExtension formType : formTypes) {
                this.fillFormTypeMenu(formType);
            }
        }
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    protected void fillInfogeneMenu() {
        JMenu infogeneMenu = new JMenu(I18n._((String)"vradi.request.infogene", (Object[])new Object[0]));
        for (String fieldName : this.getInfogeneFieldNames()) {
            infogeneMenu.add(new FieldMenuItem(fieldName));
        }
        for (String fieldName : this.getFormFieldNames()) {
            infogeneMenu.add(new FieldMenuItem(fieldName));
        }
        JMenu statusMenu = new JMenu(UIHelper.getInfogeneTraduction("status"));
        infogeneMenu.add(statusMenu);
        List<Status> statuses = VradiService.getVradiDataService().findAllStatus();
        for (Status status : statuses) {
            statusMenu.add(new FieldValueMenuItem("Infogene.status", status.getName()));
        }
        JMenu xmlStreamMenu = new JMenu(UIHelper.getFormTraduction("xmlStream"));
        infogeneMenu.add(xmlStreamMenu);
        List<XmlStream> streams = VradiService.getVradiDataService().findAllXmlStreams();
        for (XmlStream stream : streams) {
            xmlStreamMenu.add(new FieldValueMenuItem("Form.xmlStream", stream.getName()));
        }
        this.add(infogeneMenu);
    }

    protected void fillFormTypeMenu(WikittyExtension formType) {
        String formTypeName = formType.getName();
        JMenu formTypeMenu = new JMenu(formTypeName);
        formTypeMenu.add(new FormTypeMenuItem(formTypeName));
        formTypeMenu.add(new JSeparator());
        for (String fieldName : formType.getFieldNames()) {
            FieldMenuItem fieldMenu = new FieldMenuItem(formType, formTypeName + "." + fieldName);
            formTypeMenu.add(fieldMenu);
            this.formTypesFieldMenu.put(fieldName, fieldMenu);
        }
        this.formTypesMenu.put(formTypeName, formTypeMenu);
        this.add(formTypeMenu);
    }

    protected List<String> getInfogeneFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("Infogene.id");
        fieldNames.add("Infogene.objet");
        fieldNames.add("Infogene.description");
        fieldNames.add("Infogene.creationDate");
        fieldNames.add("Infogene.entity");
        fieldNames.add("Infogene.sourceText");
        fieldNames.add("Infogene.sourceURL");
        fieldNames.add("Infogene.country");
        fieldNames.add("Infogene.department");
        return fieldNames;
    }

    protected List<String> getFormFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("Form.datePub");
        fieldNames.add("Form.datePeremption");
        fieldNames.add("ModificationTag.lastModifier");
        return fieldNames;
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        for (WikittyExtension ext : added) {
            this.fillFormTypeMenu(ext);
        }
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        for (String formTypeName : removedNames) {
            JMenu formTypeMenu = this.formTypesMenu.get(formTypeName);
            if (formTypeMenu == null) continue;
            this.formTypesMenu.remove(formTypeName);
            this.remove(formTypeMenu);
        }
    }

    protected class FieldMenuItem
    extends JMenuItem
    implements ActionListener {
        protected String fieldName;
        protected String fqFieldName;
        protected FieldType fieldType;
        protected String description;
        protected String traduction;

        public FieldMenuItem(String fqFieldName) {
            this(null, fqFieldName);
        }

        public FieldMenuItem(WikittyExtension extension, String fqFieldName) {
            this.fqFieldName = fqFieldName;
            this.fieldName = WikittyUtil.getFieldNameFromFQFieldName((String)fqFieldName);
            if (extension != null) {
                this.fieldType = extension.getFieldType(fqFieldName);
                this.description = VradiHelper.getFieldTypeDescription(this.fieldType);
            }
            this.traduction = VradiHelper.getTraduction(extension, fqFieldName);
            this.addActionListener(this);
        }

        @Override
        public String getText() {
            if (this.traduction != null && !this.traduction.equals(this.fieldName)) {
                return this.traduction + " (" + this.fieldName + ")";
            }
            return this.fieldName;
        }

        public String getDisplayedText() {
            return this.fqFieldName + RequestFieldMenu.FIELD_NAME_SUFFIX;
        }

        public int getFinalCarret() {
            return -1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RSyntaxTextArea requestArea = RequestFieldMenu.this.searchUI.getRequestArea();
            int position = requestArea.getCaretPosition();
            String displayedText = this.getDisplayedText();
            requestArea.insert(displayedText, position);
            requestArea.setCaretPosition(position + displayedText.length() + this.getFinalCarret());
            RequestFieldMenu.this.searchUI.setRequest(requestArea.getText());
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return this.getToolTipText();
        }

        @Override
        public String getToolTipText() {
            if (this.description != null) {
                return this.description;
            }
            return super.getToolTipText();
        }
    }

    protected class FieldValueMenuItem
    extends FieldMenuItem {
        protected String value;

        public FieldValueMenuItem(String fqFieldName, String value) {
            super(fqFieldName);
            this.value = value;
        }

        @Override
        public String getText() {
            return I18n._((String)this.value, (Object[])new Object[0]);
        }

        @Override
        public String getDisplayedText() {
            return this.fqFieldName + ":\"" + this.value + "\"";
        }

        @Override
        public int getFinalCarret() {
            return 0;
        }
    }

    protected class FormTypeMenuItem
    extends JMenuItem
    implements ActionListener {
        protected String formTypeName;

        public FormTypeMenuItem(String formTypeName) {
            this.formTypeName = formTypeName;
            this.addActionListener(this);
        }

        @Override
        public String getText() {
            return I18n._((String)"vradi.request.searchOnExt", (Object[])new Object[0]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RSyntaxTextArea requestArea = RequestFieldMenu.this.searchUI.getRequestArea();
            int position = requestArea.getCaretPosition();
            String toDisplay = "formType:\"" + this.formTypeName + "\"";
            requestArea.insert(toDisplay, position);
            requestArea.setCaretPosition(position + toDisplay.length());
            RequestFieldMenu.this.searchUI.setRequest(requestArea.getText());
        }
    }
}

