/*
 * #%L
 * Pollen :: Vote Counting
 * $Id: Vote.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4/pollen-votecounting/src/main/java/org/chorem/pollen/votecounting/business/Vote.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.business;

/**
 * Cette classe décrit un vote du sondage. Le vote récupère l'id et le poids du
 * votant.
 *
 * @author fdesbois
 * @version $Id: Vote.java 3423 2012-06-05 16:50:22Z tchemit $
 */
public class Vote {
    /** Valeur du vote (ex : 1, 2, 3 pour condorcet ou 15 pour pourcentage) */
    private double value;

    /** Poids du vote dans le sondage */
    private double weight;

    /** Identifiant du votant */
    private String votingID;

    /**
     * Constructeur
     *
     * @param value : valeur du vote connue pour le choix
     * @param weight : poids du vote
     * @param votingID : identifiant du votant
     */
    public Vote(double value, double weight, String votingID) {
        this.value = value;
        this.weight = weight;
        this.votingID = votingID;
    }

    /**
     * getValue : Renvoie la valeur du vote
     *
     * @return valeur du vote
     */
    public double getValue() {
        return this.value;
    }

    /**
     * getWeight : Renvoie le poids du vote
     *
     * @return poids du vote
     */
    public double getWeight() {
        return this.weight;
    }

    /**
     * getVotingID : Renvoie l'identifiant du votant
     *
     * @return identifiant du votant
     */
    public String getVotingID() {
        return this.votingID;
    }
}
