/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.services;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry5.ioc.Messages;
import org.chorem.pollen.business.business.PreventRuleManager;
import org.chorem.pollen.business.dto.PollAccountDTO;
import org.chorem.pollen.business.dto.PollDTO;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.dto.VotingListDTO;
import org.chorem.pollen.business.services.ServicePoll;
import org.chorem.pollen.business.services.ServicePreventRuleImpl;
import org.chorem.pollen.ui.services.BackgroundWorker;
import org.chorem.pollen.ui.services.BackgroundWorkerImpl;
import org.chorem.pollen.ui.services.Configuration;

public class BackgroundWorkerImpl
implements BackgroundWorker {
    private Timer timer;
    private static final Log log = LogFactory.getLog(BackgroundWorkerImpl.class);
    private final Messages messages;
    private Configuration conf;
    private ServicePoll servicePoll;

    public BackgroundWorkerImpl(Messages messages, Configuration conf, ServicePoll servicePoll) {
        this.messages = messages;
        this.conf = conf;
        this.servicePoll = servicePoll;
        this.timer = new Timer();
        this.executeTasks();
    }

    public void executeTasks() {
        if (StringUtils.isEmpty((String)this.conf.getProperty("siteUrl"))) {
            log.warn((Object)"No property siteUrl. Reminder emails would not contain it");
        }
        this.timer.schedule((TimerTask)new MailingTask(this, null), 600000L, 600000L);
    }

    private void sendMailNotification(PollDTO poll, Long timeValue) {
        String voteURL = this.conf.getProperty("siteUrl") + "/poll/VoteFor/" + poll.getPollId();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("host", this.conf.getProperty("email_host"));
        data.put("port", this.conf.getProperty("email_port"));
        data.put("from", this.conf.getProperty("email_from"));
        for (PreventRuleDTO rule : poll.getPreventRuleDTOs()) {
            if (!rule.isActive()) continue;
            Boolean hasRun = false;
            PreventRuleManager manager = new PreventRuleManager(rule);
            for (VotingListDTO list : poll.getVotingListDTOs()) {
                for (PollAccountDTO account : list.getPollAccountDTOs()) {
                    if (account.getEmail() == null) continue;
                    String accountVoteURL = voteURL + ":" + account.getAccountId();
                    data.put("to", account.getEmail());
                    data.put("title", this.messages.format("reminderEmail_subject", new Object[]{poll.getTitle()}));
                    data.put("msg", this.messages.format("reminderEmail_msg", new Object[]{poll.getTitle(), account.getVotingId(), accountVoteURL}));
                    hasRun = manager.execute("rappel", Integer.valueOf(timeValue.intValue() + 1), data);
                }
            }
            if (!hasRun.booleanValue()) continue;
            rule.setActive(false);
            ServicePreventRuleImpl spr = new ServicePreventRuleImpl();
            spr.updatePreventRule(rule);
        }
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    static /* synthetic */ ServicePoll access$200(BackgroundWorkerImpl x0) {
        return x0.servicePoll;
    }

    static /* synthetic */ void access$300(BackgroundWorkerImpl x0, PollDTO x1, Long x2) {
        x0.sendMailNotification(x1, x2);
    }
}

