/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PersistentLocale;
import org.apache.tapestry5.services.Request;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.services.ServiceAuth;
import org.chorem.pollen.business.utils.MD5;
import org.chorem.pollen.ui.base.ContextLink;
import org.chorem.pollen.ui.components.FeedBack;
import org.chorem.pollen.ui.data.Lien;
import org.chorem.pollen.ui.services.Configuration;

@IncludeStylesheet(value={"context:css/main.css"})
public class Border {
    @Component(id="borderFeedback")
    private FeedBack feedback;
    @InjectComponent
    private FeedBack errorJs;
    @SessionState
    private String siteURL;
    @Parameter(required=false, defaultPrefix="literal")
    @Property
    private String feedFilename;
    @Parameter(required=false)
    @Property
    private Lien[] address;
    @Parameter(required=true, defaultPrefix="literal")
    @Property
    private String pageLogo;
    @Property
    private String logo;
    @Property
    private Lien lien;
    @Property
    private String login;
    @Property
    private String password;
    @SessionState
    @Property
    private UserDTO user;
    @Property
    private boolean userExists;
    @Property
    private DateFormat dateFormat;
    @Inject
    private Locale currentLocale;
    @Inject
    private PersistentLocale localeService;
    @Inject
    private Request request;
    @Inject
    private Messages messages;
    @Inject
    private Configuration conf;
    @Inject
    private ServiceAuth serviceAuth;
    @InjectComponent
    private ContextLink feedContext;

    public ContextLink getFeedContext() {
        return this.feedContext;
    }

    Object onSuccessFromLoginForm() {
        UserDTO userDTO = this.serviceAuth.getUser(this.login, MD5.encode((String)this.password));
        if (userDTO != null) {
            this.user = userDTO;
            this.feedback.addInfo(this.messages.get("loginOk"));
        } else {
            this.feedback.addError(this.messages.get("loginFailed"));
        }
        return null;
    }

    Object onActionFromLogout() {
        this.user = null;
        return "Index";
    }

    void onActionFromLocaleFr() {
        this.localeService.set(Locale.FRENCH);
    }

    void onActionFromLocaleEn() {
        this.localeService.set(Locale.ENGLISH);
    }

    public Date getCurrentTime() {
        return new Date();
    }

    public String getVersion() {
        return this.conf.getProperty("version");
    }

    public int getCurrentYear() {
        GregorianCalendar current = new GregorianCalendar();
        return current.get(1);
    }

    public String getContactEmail() {
        return this.conf.getProperty("adminEmail");
    }

    public boolean isUserNamed() {
        return this.user.getFirstName() != null || this.user.getLastName() != null;
    }

    public boolean isFeedFileExisting() {
        if (this.feedFilename == null) {
            return false;
        }
        File feedFile = this.feedContext.getFile(this.feedFilename);
        return feedFile.exists();
    }

    void setupRender() {
        this.dateFormat = DateFormat.getDateTimeInstance(3, 3, this.currentLocale);
        this.siteURL = "http://" + this.request.getHeader("host") + this.request.getContextPath() + "/";
        this.errorJs.addError(this.messages.get("errorJs"));
        this.logo = Locale.FRENCH.equals(this.currentLocale) ? "pollen" + this.pageLogo + "_fr.png" : "pollen" + this.pageLogo + "_en.png";
    }
}

