/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.ui.utils;

/**
 * Classe permettant de générer un mot de passe aléatoire.
 *
 * @author rannou
 * @version $Id: PasswordGenerator.java 2730 2009-08-18 07:49:38Z nrannou $
 */
public class PasswordGenerator {

    /**
     * Génération d'un mot de passe aléatoire.
     *
     * @param length longueur du mot de passe
     */
    public static String generate(int length) {
        char[] chars = new char[length];
        int c = '0';

        for (int i = 0; i < length; i++) {
            int charType = (int) (Math.random() * 3);
            switch (charType) {
            case 0:
                c = '0' + (int) (Math.random() * 10);
                break;
            case 1:
                c = 'a' + (int) (Math.random() * 26);
                break;
            case 2:
                c = 'A' + (int) (Math.random() * 26);
                break;
            default:
                break;
            }
            chars[i] = (char) c;
        }

        return String.copyValueOf(chars);
    }
}
