/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.dto.PollAccountDTO;

/*
 * Exception performing whole class analysis ignored.
 */
public class LDAPAccountUtil {
    private static final Log log = LogFactory.getLog(LDAPAccountUtil.class);

    public static List<PollAccountDTO> importList(String url) {
        return LDAPAccountUtil.importList(null, (String)url, null);
    }

    public static List<PollAccountDTO> importList(String server, String context, String filter) {
        long start = System.nanoTime();
        ArrayList<PollAccountDTO> accounts = new ArrayList<PollAccountDTO>();
        try {
            Properties env = new Properties();
            if (server != null) {
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://" + server + "/");
            }
            InitialDirContext ictx = new InitialDirContext(env);
            SearchControls control = new SearchControls();
            control.setSearchScope(2);
            NamingEnumeration<SearchResult> e = ictx.search(context, filter, control);
            while (e.hasMore()) {
                SearchResult r = e.next();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Result: " + r.getName() + "(object: " + r.getClassName() + ")"));
                }
                Attribute nameAttr = r.getAttributes().get("cn");
                Attribute emailAttr = r.getAttributes().get("mail");
                if (nameAttr == null) continue;
                PollAccountDTO account = new PollAccountDTO();
                account.setVotingId(nameAttr.get().toString());
                account.setEmail(emailAttr.get().toString());
                accounts.add(account);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("New account - name: " + nameAttr.get().toString() + ", email: " + emailAttr.get().toString()));
            }
        }
        catch (NamingException e) {
            log.error((Object)"Exception de nommage lors de l'import depuis LDAP", (Throwable)e);
        }
        long duration = (System.nanoTime() - start) / 1000000000L;
        if (log.isInfoEnabled()) {
            log.info((Object)(accounts.size() + " comptes import\u00e9s en " + duration + " sec."));
        }
        return accounts;
    }
}

