/* 
 * pollen.js
 * fonctions utiles pour Pollen UI
 */

/* 
 * Active ou désactive un élément à partir d'une checkbox 
 * checkbox : la checkbox
 * element : l'élément à activer ou désactiver
 */
function cbDisable(checkbox, element) {
	element.disabled = checkbox.checked;
	element.checked = checkbox.checked;
}

/*
 * Callback appelé lors de la sélection d'un type de choix
 * response : JSONObject contenant l'identifiant de la zone et l'URL pour la mettre à jour
 */
function onCompleteZoneUpdate(response) {
	var zoneManager = Tapestry.findZoneManagerForZone(response.zoneId);
	zoneManager.updateFromURL(response.link);
}