/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: GenerateChart.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.4/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/io/GenerateChart.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.io;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.SortOrder;

import java.awt.Color;
import java.awt.Font;
import java.util.List;

/**
 * Action to generate a chart given the values (and optional subtitles).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GenerateChart extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(GenerateChart.class);

    /** diagramme de type PIE. */
    public static final int PIE = 1;

    /** diagramme de type PIE3D. */
    public static final int PIE3D = 2;

    /** diagramme de type RING. */
    public static final int RING = 3;

    protected int type;

    protected List<String> values;

    protected List<String> subtitles;

    protected int width;

    protected int height;

    protected String title;

    protected JFreeChart chart;

    public void setType(int type) {
        this.type = type;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public void setSubtitles(List<String> subtitles) {
        this.subtitles = subtitles;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JFreeChart getChart() {
        return chart;
    }

    @Override
    public String execute() throws Exception {

        DefaultKeyedValues vals = new DefaultKeyedValues();

        if (log.isInfoEnabled()) {
            log.info("Title     = " + title);
            log.info("Values    = " + values);
            log.info("Subtitles = " + subtitles);
        }

        for (int i = 0, nbValues = values.size() / 2; i < nbValues; i += 1) {
            String key = values.get(2 * i);
            Double value = Double.valueOf(values.get(2 * i + 1));
            vals.addValue(key, value);
        }

        vals.sortByValues(SortOrder.DESCENDING);
        PieDataset data = new DefaultPieDataset(vals);

        // create the chart look according to the type
        PiePlot plot;
        switch (type) {
            case PIE:
                plot = new PiePlot(data);
                break;
            case PIE3D:
                plot = new PiePlot3D(data);
                break;
            case RING:
                plot = new RingPlot(data);
                break;
            default:
                plot = new PiePlot(data);
                break;
        }

        //plot.setForegroundAlpha(0.7f);
        plot.setCircular(true);
        plot.setLabelGenerator(new StandardPieSectionLabelGenerator("{0} {2}"));
        plot.setLegendLabelGenerator(new StandardPieSectionLabelGenerator(
                "{0} = {1}"));
        plot.setNoDataMessage("No Data");

        chart = new JFreeChart(plot);
        chart.setTitle(new TextTitle(title, new Font(Font.SANS_SERIF,
                                                     Font.BOLD, 12)));
        chart.setBackgroundPaint(new Color(255, 255, 255));

        if (CollectionUtils.isNotEmpty(subtitles)) {
            Font subtitlesFont = new Font(Font.SANS_SERIF, Font.ITALIC, 11);
            for (int i = 0; i < subtitles.size(); i += 2) {
                String subtitle = subtitles.get(i) + "=" + subtitles.get(i + 1);
                TextTitle textTitle = new TextTitle(subtitle, subtitlesFont);
                chart.addSubtitle(textTitle);
            }
        }
        return SUCCESS;
    }
}
