package org.chorem.pollen.ui.interceptors;
/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: PollenSecurityInterceptor.java 3612 2012-08-13 14:15:01Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.2/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/interceptors/PollenSecurityInterceptor.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import org.apache.struts2.StrutsStatics;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;

import javax.servlet.http.HttpServletRequest;

/**
 * Interceptor to inject the {@link PollenUserSecurityContext} for
 * {@link PollenUserSecurityAware}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @see PollenUserSecurityAware
 * @see PollenUserSecurityContext
 * @since 1.4.5
 */
public class PollenSecurityInterceptor extends AbstractInterceptor implements StrutsStatics {

    private static final long serialVersionUID = 1L;

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        final Object action = invocation.getAction();
        final ActionContext context = invocation.getInvocationContext();

        if (action instanceof PollenUserSecurityAware) {

            HttpServletRequest request = (HttpServletRequest) context.get(HTTP_REQUEST);
            PollenUserSecurityContext userSecurityContext = PollenUIUtils.getUserSecurityContext(request);
            ((PollenUserSecurityAware) action).setPollenUserSecurityContext(userSecurityContext);
        }
        return invocation.invoke();
    }
}
