/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.security;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.impl.SecurityService;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.security.AbstractPollenAuthorization;
import org.chorem.pollen.ui.security.AdminUserRequired;
import org.nuiton.i18n.I18n;

public class PollResultAccessRequired
extends AbstractPollenAuthorization {
    protected final AdminUserRequired adminFilter = new AdminUserRequired();

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        String errorMessage;
        PollenServiceContext serviceContext = this.getServiceContext(request);
        PollUri pollUri = this.getPollUri(request);
        SecurityService securityService = (SecurityService)serviceContext.newService(SecurityService.class);
        Poll poll = this.getPollIdSane(pollUri, serviceContext, request);
        boolean isAccessAllowed = poll != null;
        SecurityService.AccountIdRole accountIdRole = null;
        if (isAccessAllowed) {
            boolean isAdmin = this.adminFilter.isAccessAllowed(request, response, mappedValue);
            boolean withAccountId = pollUri.isAccountIdNotBlank();
            if (withAccountId) {
                accountIdRole = securityService.getAccountIdRole(poll, pollUri.getAccountId());
                if (accountIdRole == SecurityService.AccountIdRole.UNDEFINED) {
                    isAccessAllowed = false;
                    this.registerError(request, I18n.n_((String)"pollen.security.error.bad.accountId", (Object[])new Object[0]));
                }
            } else {
                UserAccount userAccount = this.getPollenUserAccount(request);
                boolean isCreator = securityService.isPollCreator(poll, null, userAccount);
                if (isCreator) {
                    accountIdRole = SecurityService.AccountIdRole.CREATOR;
                }
            }
            if (isAdmin) {
                accountIdRole = SecurityService.AccountIdRole.CREATOR;
            }
        }
        if (isAccessAllowed && (errorMessage = securityService.isCanAccessResult(poll, accountIdRole)) != null) {
            isAccessAllowed = false;
            this.registerError(request, errorMessage);
        }
        if (isAccessAllowed) {
            PollenUIUtils.setAccountIdRole((ServletRequest)request, accountIdRole);
        }
        return isAccessAllowed;
    }
}

