/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: DisplayVotingList.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/form/DisplayVotingList.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.form;

import com.google.common.base.Function;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * To display a voting list of a poll (use at a poll creation).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DisplayVotingList extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    /** Type of the voting list. */
    protected String votingListType;

    /** Number of person to display. */
    protected int votingListNumber;

    /** The voting list ot display. */
    protected VotingList votingList;

    public int getVotingListNumber() {
        return votingListNumber;
    }

    public void setVotingListNumber(int votingListNumber) {
        this.votingListNumber = votingListNumber;
    }

    public VotingList getVotingList() {
        return votingList;
    }

    public String getVotingListType() {
        return votingListType;
    }

    public void setVotingListType(String votingListType) {
        this.votingListType = votingListType;
    }

    public int getStartNumber() {
        return 0;
    }

    @Override
    public String execute() throws Exception {

        Function<PersonToList, PersonToList> persontoListCreator =
                PollenServiceFunctions.newPersonToListCreator();
        Function<VotingList, VotingList> votingListCreator =
                PollenServiceFunctions.newVotingListCreator(persontoListCreator);

        votingList = votingListCreator.apply(null);

        PollenServiceFunctions.fillVotingList(votingList,
                                              persontoListCreator, 5);
        return SUCCESS;
    }
}
