/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: GetPolls.java 3386 2012-05-24 18:13:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetPolls.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.nuiton.util.beans.Binder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Obtain paginated users.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetPolls extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] polls;

    public Map<String, Object>[] getPolls() {
        return polls;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        PollService pollService = newService(PollService.class);

        List<Poll> pollList = pollService.getPolls(pager);

        polls = new Map[pollList.size()];
        Binder<Poll, Poll> binder =
                PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;
        for (Poll poll : pollList) {

            Map<String, Object> map = pollService.pollToMap(poll, binder);

//            Map<String, Object> map = binder.obtainProperties(
//                    poll,
//                    Poll.PROPERTY_TITLE,
//                    Poll.PROPERTY_POLL_ID,
//                    Poll.PROPERTY_DESCRIPTION,
//                    Poll.PROPERTY_BEGIN_DATE,
//                    Poll.PROPERTY_END_DATE
//            );
//            map.put("id", poll.getTopiaId());
            map.put("moderateId", poll.getAdminId());
            map.put("resultId", poll.getAdminId());
            map.put("adminId", poll.getAdminId());

            Set<String> functions = getPollFunctions(poll);
            map.put("functions", functions);
            polls[index++] = map;
        }

        return SUCCESS;
    }

    protected Set<String> getPollFunctions(Poll poll) {
        Set<String> result = Sets.newHashSet();
        result.add("moderate");
        result.add("result");
        if (!poll.isClosed()) {

            // poll is not closed
            result.add("edit");
            result.add("close");
        }
        result.add("export");
        result.add("clone");
        result.add("delete");
        return result;
    }
}
