/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.security;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.security.AbstractPollenAuthorization;

public class PollRequired
extends AbstractPollenAuthorization {
    private static final Log log = LogFactory.getLog(PollRequired.class);

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        boolean isAccessAllowed;
        PollUri pollUri = this.getPollUri(request);
        if (pollUri == null) {
            isAccessAllowed = false;
        } else {
            PollenServiceContext serviceContext = this.getServiceContext(request);
            PollService pollService = (PollService)serviceContext.newService(PollService.class);
            try {
                pollService.checkPoll(pollUri);
                isAccessAllowed = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can access to this poll " + pollUri.getPollId()));
                }
            }
            catch (PollNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Poll not found!");
                }
                isAccessAllowed = false;
            }
        }
        return isAccessAllowed;
    }
}

