/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.ChoiceDao;
import org.chorem.pollen.persistence.entity.ChoiceType;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.services.bean.ChoiceBean;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.ReportResumeBean;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.InvalidEntityLinkException;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenResourceService;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.nuiton.i18n.I18n;

public class ChoiceService
extends PollenServiceSupport {
    public ChoiceBean toChoiceBean(Choice entity) {
        ChoiceBean bean = new ChoiceBean();
        bean.setEntityId(entity.getTopiaId());
        if (entity.getCreator() == null || entity.getCreator().getPermission() == null || this.isNotPermitted(PollenPermissions.edit(entity))) {
            bean.setPermission(null);
        } else {
            bean.setPermission(entity.getCreator().getPermission().getToken());
        }
        if (entity.getChoiceType() == ChoiceType.RESOURCE) {
            bean.setChoiceValue(this.getPollenResourceService().getReduceIdByTopiaId(entity.getChoiceValue()));
        } else {
            bean.setChoiceValue(entity.getChoiceValue());
        }
        bean.setDescription(entity.getDescription());
        bean.setChoiceType(entity.getChoiceType());
        bean.setChoiceOrder(entity.getChoiceOrder());
        if (this.isPermitted(PollenPermissions.edit(entity))) {
            ReportResumeBean report = this.getReportService().getReport(entity.getTopiaId());
            bean.setReport(report);
        }
        boolean choiceIsDeletable = this.isPermitted(PollenPermissions.delete(entity));
        bean.setChoiceIsDeletable(choiceIsDeletable);
        return bean;
    }

    public Choice toChoice(ChoiceBean bean) {
        Choice entity = new Choice();
        entity.setTopiaId(bean.getEntityId());
        entity.setChoiceValue(bean.getChoiceValue());
        entity.setDescription(bean.getDescription());
        entity.setChoiceType(bean.getChoiceType());
        entity.setChoiceOrder(bean.getChoiceOrder());
        return entity;
    }

    public List<ChoiceBean> getChoices(String questionId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(questionId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.read(question));
        List choices = this.getChoiceDao().findAllByQuestionOrdered(question);
        return choices.stream().map(this::toChoiceBean).toList();
    }

    public List<ChoiceBean> getChoices(Question question) {
        this.checkIsConnectedRequired();
        List choices = this.getChoiceDao().findAllByQuestionOrdered(question);
        return choices.stream().map(this::toChoiceBean).toList();
    }

    public ChoiceBean getChoice(String questionId, String choiceId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(questionId);
        this.checkNotNull(choiceId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.read(question));
        Choice choice = this.getChoice(question, choiceId);
        return this.toChoiceBean(choice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollenEntityRef<Choice> addChoice(String pollId, String questionId, ChoiceBean choice) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(pollId);
        this.checkNotNull(questionId);
        this.checkNotNull(choice);
        this.checkIsNotPersisted(choice);
        Object object = ChoiceService.getLock(questionId);
        synchronized (object) {
            Poll poll = this.getPollService().getPoll0(pollId);
            Question question = this.getQuestionService().getQuestion0(questionId);
            this.checkPermission(PollenPermissions.addChoice(question));
            Poll questionPoll = question.getPoll();
            if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
                throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
            }
            List existingChoices = this.getChoiceDao().findAllByQuestionOrdered(question);
            ErrorMap errorMap = this.checkChoice(existingChoices, choice);
            errorMap.failIfNotEmpty();
            Choice result = this.saveChoice(question, choice);
            this.commit();
            this.getNotificationService().onChoiceAdded(question, result);
            this.getFeedService().onChoiceAdded(question, result);
            return PollenEntityRef.of(result);
        }
    }

    public ChoiceBean editChoice(String questionId, ChoiceBean choice) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(choice);
        this.checkIsPersisted(choice);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Choice choiceBd = this.getChoice(question, choice.getEntityId());
        this.checkPermission(PollenPermissions.edit(choiceBd));
        List existingChoices = this.getChoiceDao().findAllByQuestionOrdered(question);
        ErrorMap errorMap = this.checkChoice(existingChoices, choice);
        errorMap.failIfNotEmpty();
        Choice result = this.saveChoice(question, choice);
        this.commit();
        this.getNotificationService().onChoiceEdited(question, result);
        return this.toChoiceBean(result);
    }

    public void deleteChoice(String questionId, String choiceId) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(questionId);
        this.checkNotNull(choiceId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Choice choice = this.getChoice(question, choiceId);
        this.checkPermission(PollenPermissions.delete(choice));
        List existingChoices = this.getChoiceDao().findAllByQuestionOrdered(question);
        if (existingChoices.size() == 1) {
            ErrorMap errors = new ErrorMap();
            errors.addError("choice", I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.choice.mandatory", (Object[])new Object[0]));
            errors.failIfNotEmpty();
        }
        this.getChoiceDao().delete(choice);
        this.commit();
        this.getNotificationService().onChoiceDeleted(question, choice);
    }

    protected Choice getChoice(Question question, String choiceId) {
        Choice result = (Choice)this.getChoiceDao().forTopiaIdEquals(choiceId).findUnique();
        if (!question.equals((Object)result.getQuestion())) {
            throw new InvalidEntityLinkException("question", (PollenEntity)result, (PollenEntity)question);
        }
        return result;
    }

    protected void saveChoices(Question question, List<ChoiceBean> choicesToSave) {
        List existingChoices;
        boolean questionExists = question.isPersisted();
        List list = existingChoices = questionExists ? this.getChoiceDao().findAllByQuestionOrdered(question) : new ArrayList();
        if (CollectionUtils.isNotEmpty(choicesToSave)) {
            for (ChoiceBean choice : choicesToSave) {
                Choice persistedChoice = this.saveChoice(question, choice);
                existingChoices.remove(persistedChoice);
            }
        }
        if (CollectionUtils.isNotEmpty(existingChoices)) {
            this.getChoiceDao().deleteAll(existingChoices);
        }
    }

    protected Choice saveChoice(Question question, ChoiceBean choice) {
        Choice toSave;
        ChoiceDao choiceDao = this.getChoiceDao();
        boolean choiceExists = choice.isPersisted();
        if (choiceExists) {
            toSave = this.getChoice(question, choice.getEntityId());
            if (!(toSave.getChoiceType() != ChoiceType.RESOURCE || choice.getChoiceType() == ChoiceType.RESOURCE && toSave.getChoiceValue().equals(this.getPollenResourceService().getTopiaIdByReduceId(choice.getChoiceValue())))) {
                this.getPollenResourceDao().delete(this.getPollenResourceService().getResource0(toSave.getChoiceValue()));
            }
            toSave.setChoiceType(choice.getChoiceType());
            toSave.setCreator(question.getPoll().getCreator());
        } else {
            toSave = (Choice)choiceDao.newInstance();
            toSave.setChoiceType(choice.getChoiceType());
            toSave.setCreator(question.getPoll().getCreator());
            toSave.setQuestion(question);
            choiceDao.create((PollenEntity)toSave);
        }
        toSave.setChoiceOrder(choice.getChoiceOrder());
        if (ChoiceType.RESOURCE.equals((Object)toSave.getChoiceType())) {
            toSave.setChoiceValue(this.getPollenResourceService().getTopiaIdByReduceId(choice.getChoiceValue()));
        } else {
            toSave.setChoiceValue(choice.getChoiceValue());
        }
        toSave.setDescription(choice.getDescription());
        return toSave;
    }

    protected ErrorMap checkChoice(List<Choice> existingChoices, ChoiceBean choice) {
        ErrorMap errors = new ErrorMap();
        boolean choiceExists = choice.isPersisted();
        HashSet choiceNames = Sets.newHashSet();
        boolean withChoiceType = this.checkNotNull(errors, "choiceType", choice.getChoiceType(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.choice.choiceTypeEmpty", (Object[])new Object[0]));
        if (CollectionUtils.isNotEmpty(existingChoices)) {
            for (Choice choice1 : existingChoices) {
                if (choiceExists && choice1.getTopiaId().equals(choice.getEntityId())) continue;
                choiceNames.add(choice1.getChoiceValue());
            }
        }
        if (withChoiceType) {
            switch (choice.getChoiceType()) {
                case TEXT: {
                    String choiceName = choice.getChoiceValue();
                    boolean nameNotBlank = this.checkNotBlank(errors, "choiceValue", choiceName, I18n.l((Locale)this.getLocale(), (String)"pollen.error.choice.choiceNameEmpty", (Object[])new Object[0]));
                    if (!nameNotBlank) break;
                    boolean nameAdded = choiceNames.add(choiceName);
                    this.check(errors, "choiceValue", nameAdded, I18n.l((Locale)this.getLocale(), (String)"pollen.error.choice.choiceNameExist", (Object[])new Object[0]));
                    break;
                }
                case DATE: 
                case DATETIME: {
                    Calendar choiceDate = null;
                    if (choice.getChoiceValue() != null) {
                        try {
                            choiceDate = Calendar.getInstance();
                            choiceDate.setTimeInMillis(Long.parseLong(choice.getChoiceValue()));
                        }
                        catch (NumberFormatException e) {
                            this.check(errors, "choiceValue", false, I18n.l((Locale)this.getLocale(), (String)"pollen.error.choice.choiceDateInvalid", (Object[])new Object[]{choice.getChoiceValue()}));
                        }
                        if (choiceDate == null) break;
                        boolean dateAdded = choiceNames.add(String.valueOf(choiceDate.getTime()));
                        this.check(errors, "choiceValue", dateAdded, I18n.l((Locale)this.getLocale(), (String)"pollen.error.choice.choiceDateExist", (Object[])new Object[0]));
                        break;
                    }
                    this.check(errors, "choiceValue", false, I18n.l((Locale)this.getLocale(), (String)"pollen.error.choice.choiceDateEmpty", (Object[])new Object[0]));
                    break;
                }
                case RESOURCE: {
                    boolean hasResource = this.checkNotBlank(errors, "choiceValue", choice.getChoiceValue(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.resource.empty", (Object[])new Object[0]));
                    if (!hasResource) break;
                    PollenResourceService resourceService = this.getPollenResourceService();
                    PollenResource resource = resourceService.getResource0(resourceService.getTopiaIdByReduceId(choice.getChoiceValue()));
                    this.checkNotBlank(errors, "choiceValue", resource.getName(), I18n.l((Locale)this.getLocale(), (String)"pollen.error.resource.notExist", (Object[])new Object[0]));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected value : " + String.valueOf(choice.getChoiceType()));
                }
            }
        }
        return errors;
    }

    public long getChoiceCount(Question question) {
        this.checkIsConnectedRequired();
        return this.getChoiceDao().forQuestionEquals(question).count();
    }
}

