/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollActions;
import org.chorem.pollen.services.PollenServiceSupport;

public class PollUrlService
extends PollenServiceSupport {
    public PollUrl getPollSummaryUrl(Poll poll) {
        PollUrl result = this.newPollUrl(PollActions.SUMMARY, poll, true);
        return result;
    }

    public PollUrl getPollCloneUrl(Poll poll) {
        PollUrl result = this.newPollUrl(PollActions.CLONE, poll, true);
        return result;
    }

    public PollUrl getPollExportUrl(Poll poll) {
        PollUrl result = this.newPollUrl(PollActions.EXPORT, poll, true);
        return result;
    }

    public PollUrl getPollVoteUrl(Poll poll) {
        PollUrl result = this.newPollUrl(PollActions.VOTE, poll, false);
        return result;
    }

    public PollUrl getPollVoteUrl(Poll poll, PollAccount pollAccount) {
        PollUrl result = this.newPollUrl(PollActions.VOTE, poll, pollAccount);
        return result;
    }

    public PollUrl getPollModerateUrl(Poll poll) {
        PollUrl result = this.newPollUrl(PollActions.MODERATE, poll, true);
        return result;
    }

    public PollUrl getPollEditUrl(Poll poll) {
        PollUrl result = this.newPollUrl(PollActions.EDIT, poll, true);
        return result;
    }

    public PollUrl getPollResultUrl(Poll poll) {
        PollUrl result = this.newPollUrl(PollActions.RESULT, poll, !poll.isPublicResults());
        return result;
    }

    protected PollUrl newPollUrl(PollActions action, Poll poll, boolean admin) {
        Preconditions.checkNotNull((Object)poll);
        return this.newPollUrl(action, poll, admin ? poll.getCreator() : null);
    }

    protected PollUrl newPollUrl(PollActions action, Poll poll, PollAccount pollAccount) {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkNotNull((Object)action);
        String prefix = action.getActionPrefix() + '/';
        String applicationUrl = this.serviceContext.getApplicationURL().toString();
        if (!applicationUrl.endsWith("/")) {
            applicationUrl = applicationUrl + '/';
        }
        String baseUrl = applicationUrl + prefix;
        PollUri pollUri = pollAccount == null ? PollUri.newPollUri(poll.getPollId()) : PollUri.newPollUri(poll.getPollId(), pollAccount.getAccountId());
        PollUrl result = PollUrl.newPollUrl(baseUrl, pollUri);
        return result;
    }
}

