/*
 * #%L
 * Pollen :: Services
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package org.chorem.pollen.services;

import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.votecounting.VoteCountingFactory;
import org.nuiton.topia.TopiaContext;

import java.net.URL;
import java.util.Date;
import java.util.Locale;

/**
 * This contract represents objects you must provide when asking for a service.
 * Objects provided may be injected in services returned by
 * {@link PollenServiceFactory#newService(Class, PollenServiceContext)}
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public interface PollenServiceContext {

    TopiaContext getTransaction();

    void setTransaction(TopiaContext transaction);

    Locale getLocale();

    URL getApplicationURL();

    boolean isCanSendEmail();

    PollenConfiguration getConfiguration();

    PollenServiceFactory getServiceFactory();

    <E extends PollenService> E newService(Class<E> clazz);

    /** @return the current date */
    Date getCurrentTime();

    VoteCountingFactory getVoteCountingFactory();

    /**
     * Generates a unique id usable for {@link Poll#getPollId()} or
     * {@link PollAccount#getAccountId()}.
     *
     * @return a fresh generated id
     * @since 1.5
     */
    String generateId();

}
