/*
 * #%L
 * Pollen :: Services
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.entities.migration;

import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClassNG;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

import java.util.Arrays;
import java.util.List;

/**
 * Migration for version {@code 1.2}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class PollenMigrationCallbackV1_2 extends TopiaMigrationCallbackByClassNG.MigrationCallBackForVersion {

    @Override
    public Version getVersion() {
        return VersionUtil.valueOf("1.2");
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx,
                                          List<String> queries,
                                          boolean showSql,
                                          boolean showProgression) throws TopiaException {


        Dialect dialect =
                Dialect.getDialect(tx.getHibernateConfiguration().getProperties());

        String[] sqls = null;

        if (dialect instanceof PostgreSQLDialect) {
            sqls = new String[]{
                    "alter table poll add endchoicedate timestamp without time zone;"};
        } else if (dialect instanceof H2Dialect) {
            sqls = new String[]{
                    "alter table poll add endchoicedate timestamp before begindate;"};
        }

        queries.addAll(Arrays.asList(sqls));

    }
}
