/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.GroupOfVoter;
import org.chorem.pollen.votecounting.model.GroupVoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;
import org.chorem.pollen.votecounting.strategy.VoteCountingStrategy;
import org.chorem.pollen.votecounting.strategy.VoteCountingStrategyProvider;

public class PollVoteCountingService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(PollVoteCountingService.class);
    private VoteCountingStrategyProvider provider;

    public VoteCountingStrategyProvider getProvider() {
        if (this.provider == null) {
            this.provider = this.serviceContext.getVoteCountingStrategyProvider();
        }
        return this.provider;
    }

    public void setProvider(VoteCountingStrategyProvider provider) {
        this.provider = provider;
    }

    public VoteCountingResult voteCount(int strategyId, Set<Voter> voter) {
        Preconditions.checkNotNull((Object)this.getProvider());
        Preconditions.checkNotNull(voter);
        VoteCountingStrategy strategy = this.getProvider().getStrategy(strategyId);
        Preconditions.checkNotNull((Object)strategy);
        VoteCountingResult result = strategy.votecount(voter);
        return result;
    }

    public GroupVoteCountingResult voteCountByGroup(int strategyId, Set<Voter> voter) {
        Preconditions.checkNotNull((Object)this.getProvider());
        Preconditions.checkNotNull(voter);
        VoteCountingStrategy strategy = this.getProvider().getStrategy(strategyId);
        Preconditions.checkNotNull((Object)strategy);
        GroupOfVoter group = GroupOfVoter.newVoter(null, (double)1.0, null, voter);
        HashMap groupResults = Maps.newHashMap();
        this.voteCount(strategy, group, groupResults);
        VoteCountingResult mainResult = (VoteCountingResult)groupResults.remove(group);
        GroupVoteCountingResult result = GroupVoteCountingResult.newResult((VoteCountingResult)mainResult, (Map)groupResults);
        return result;
    }

    protected void voteCount(VoteCountingStrategy strategy, GroupOfVoter group, Map<GroupOfVoter, VoteCountingResult> results) {
        Set voters = group.getVoters();
        for (Voter voter : voters) {
            if (!(voter instanceof GroupOfVoter)) continue;
            this.voteCount(strategy, (GroupOfVoter)voter, results);
        }
        VoteCountingResult voteCountingResult = strategy.votecount(voters);
        results.put(group, voteCountingResult);
        for (ChoiceScore choiceScore : voteCountingResult.getScores()) {
            VoteForChoice voteForChoice = VoteForChoice.newVote((String)choiceScore.getChoiceId(), (Double)choiceScore.getScoreValue().doubleValue());
            group.addVoteForChoice(voteForChoice);
        }
    }
}

