/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.impl;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.bean.PollDateChoice;
import org.chorem.pollen.bean.PollImageChoice;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceDAO;
import org.chorem.pollen.business.persistence.ChoiceImpl;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.PreventRuleDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListDAO;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.PollenServiceFunctions;
import org.chorem.pollen.services.PollenServiceSupport;
import org.chorem.pollen.services.exceptions.PollAccountNotFound;
import org.chorem.pollen.services.exceptions.PollChoiceNotFoundException;
import org.chorem.pollen.services.exceptions.PollNotFoundException;
import org.chorem.pollen.services.exceptions.UnauthorizedPollAccessException;
import org.chorem.pollen.services.impl.EmailService;
import org.chorem.pollen.services.impl.PollFeedService;
import org.chorem.pollen.services.impl.PreventRuleService;
import org.chorem.pollen.services.impl.UserService;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

public class PollService
extends PollenServiceSupport {
    private static final Log log = LogFactory.getLog(PollService.class);
    public static final String THUMB_PREFIX = "thumb_";

    public Poll getNewPoll(UserAccount user) {
        PollDAO pollDAO = (PollDAO)this.getDAO(Poll.class);
        Poll result = (Poll)this.newInstance(pollDAO);
        PollenConfiguration configuration = this.getConfiguration();
        result.setChoiceType(configuration.getDefaultChoiceType());
        result.setVoteCountingType(configuration.getDefaultVoteCountingType());
        result.setPollType(configuration.getDefaultPollType());
        PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
        PollAccount creator = (PollAccount)this.newInstance(pollAccountDAO);
        creator.setAccountId(this.serviceContext.createPollenUrlId());
        if (user != null) {
            creator.setVotingId(user.getDisplayName());
            creator.setEmail(user.getEmail());
            creator.setUserAccount(user);
        }
        result.setCreator(creator);
        result.setPollId(this.serviceContext.createPollenUrlId());
        return result;
    }

    public Poll getPollEditable(String pollUid, UserAccount userAccount, boolean clone) {
        Poll poll;
        Poll result = pollUid == null ? this.getNewPoll(userAccount) : ((poll = this.getPollByPollId(pollUid)) == null ? this.getNewPoll(userAccount) : this.getNewPollCopy(poll, userAccount, clone));
        return result;
    }

    protected Poll getNewPollCopy(Poll source, UserAccount userAccount, boolean clone) {
        Preconditions.checkNotNull((Object)source);
        PollDAO pollDAO = (PollDAO)this.getDAO(Poll.class);
        Poll result = (Poll)this.newInstance(pollDAO);
        PollenBinderHelper.simpleCopy((TopiaEntity)source, (TopiaEntity)result, (!clone ? 1 : 0) != 0);
        if (clone) {
            result.setPollId(this.serviceContext.createPollenUrlId());
        }
        PollAccount creatorLoaded = source.getCreator();
        PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
        PollAccount creatorEditable = (PollAccount)this.newInstance(pollAccountDAO);
        result.setCreator(creatorEditable);
        PollenBinderHelper.simpleCopy((TopiaEntity)creatorLoaded, (TopiaEntity)creatorEditable, (!clone ? 1 : 0) != 0);
        if (clone) {
            creatorEditable.setAccountId(this.serviceContext.createPollenUrlId());
        }
        if (creatorLoaded.getUserAccount() != null) {
            creatorEditable.setUserAccount(creatorLoaded.getUserAccount());
        } else if (userAccount != null) {
            creatorEditable.setUserAccount(userAccount);
        }
        Function<Choice, Choice> choiceCreator = PollenServiceFunctions.newChoiceCreator(source.getChoiceType());
        Iterable choices = Iterables.transform((Iterable)source.getChoice(), choiceCreator);
        for (Choice choiceLoaded : choices) {
            if (clone) {
                choiceLoaded.setTopiaId(null);
            }
            result.addChoice(choiceLoaded);
        }
        VotingListDAO votingListDAO = (VotingListDAO)this.getDAO(VotingList.class);
        PersonToListDAO personToListDAO = (PersonToListDAO)this.getDAO(PersonToList.class);
        for (VotingList votingListLoaded : source.getVotingList()) {
            VotingList votingListEditable = (VotingList)this.newInstance(votingListDAO);
            result.addVotingList(votingListEditable);
            PollenBinderHelper.simpleCopy((TopiaEntity)votingListLoaded, (TopiaEntity)votingListEditable, (boolean)false);
            for (PersonToList personToListLoaded : votingListLoaded.getPollAccountPersonToList()) {
                PersonToList personToListEditable = (PersonToList)this.newInstance(personToListDAO);
                votingListEditable.addPollAccountPersonToList(personToListEditable);
                PollenBinderHelper.simpleCopy((TopiaEntity)personToListLoaded, (TopiaEntity)personToListEditable, (boolean)false);
                PollAccount personLoaded = personToListLoaded.getPollAccount();
                PollAccount personEditable = (PollAccount)this.newInstance(pollAccountDAO);
                personToListEditable.setPollAccount(personEditable);
                PollenBinderHelper.simpleCopy((TopiaEntity)personLoaded, (TopiaEntity)personEditable, (boolean)false);
                if (!clone) continue;
                personEditable.setAccountId(this.serviceContext.createPollenUrlId());
            }
        }
        PreventRuleDAO preventRuleDAO = (PreventRuleDAO)this.getDAO(PreventRule.class);
        for (PreventRule preventRuleLoaded : source.getPreventRule()) {
            PreventRule preventRuleEditable = (PreventRule)this.newInstance(preventRuleDAO);
            PollenBinderHelper.simpleCopy((TopiaEntity)preventRuleLoaded, (TopiaEntity)preventRuleEditable, (!clone ? 1 : 0) != 0);
            result.addPreventRule(preventRuleEditable);
        }
        result.setVote(source.getVote());
        return result;
    }

    public Poll createPoll(Poll poll) {
        PollDAO pollDAO = (PollDAO)this.getDAO(Poll.class);
        Poll result = (Poll)this.create(pollDAO);
        result.setAnonymous(poll.isAnonymous());
        result.setAnonymousVoteAllowed(poll.isAnonymousVoteAllowed());
        result.setChoiceAddAllowed(poll.isChoiceAddAllowed());
        result.setBeginChoiceDate(poll.getBeginChoiceDate());
        result.setBeginDate(poll.getBeginDate());
        result.setChoiceType(poll.getChoiceType());
        result.setContinuousResults(poll.isContinuousResults());
        result.setDescription(poll.getDescription());
        result.setEndDate(poll.getEndDate());
        result.setEndChoiceDate(poll.getEndChoiceDate());
        result.setPollId(poll.getPollId());
        result.setPollType(poll.getPollType());
        result.setMaxChoiceNb(poll.getMaxChoiceNb());
        result.setPublicResults(poll.isPublicResults());
        result.setTitle(poll.getTitle());
        result.setVoteCountingType(poll.getVoteCountingType());
        PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
        PollAccount creatorCreated = (PollAccount)this.create(pollAccountDAO);
        PollAccount creator = poll.getCreator();
        creatorCreated.setVotingId(creator.getVotingId());
        creatorCreated.setEmail(creator.getEmail());
        creatorCreated.setUserAccount(creator.getUserAccount());
        creatorCreated.setAccountId(creator.getAccountId());
        result.setCreator(creatorCreated);
        for (Choice choice : poll.getChoice()) {
            this.saveChoice(result, choice);
        }
        for (Choice choice : poll.getPreventRule()) {
            this.savePreventRule(result, (PreventRule)choice);
        }
        try {
            for (VotingList votingList : poll.getVotingList()) {
                this.saveVotingList(result, votingList, null);
            }
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Can't save votingLists", (Throwable)e);
        }
        this.commitTransaction("Could not create poll " + poll.getTitle());
        PollUrl pollVoteUrl = this.getPollVoteUrl(poll, false);
        PollUrl pollModerateUrl = this.getPollVoteUrl(poll, true);
        PollUrl pollEditUrl = this.getPollEditUrl(poll);
        EmailService emailService = this.newService(EmailService.class);
        emailService.onPollCreated(result, pollVoteUrl, pollModerateUrl, pollEditUrl);
        PollFeedService pollFeedService = this.newService(PollFeedService.class);
        pollFeedService.onPollCreated(result, pollVoteUrl);
        return result;
    }

    public void updatePoll(Poll poll) throws PollNotFoundException {
        Poll pollToUpdate = this.getEntityById(Poll.class, poll.getTopiaId());
        if (pollToUpdate == null) {
            throw new PollNotFoundException();
        }
        boolean voteStarted = pollToUpdate.sizeVote() > 0;
        PollAccount creatorToUpdate = pollToUpdate.getCreator();
        PollenBinderHelper.simpleCopy((TopiaEntity)poll, (TopiaEntity)pollToUpdate, (boolean)false);
        PollAccount creator = poll.getCreator();
        creatorToUpdate.setUserAccount(creator.getUserAccount());
        creatorToUpdate.setVotingId(creator.getVotingId());
        creatorToUpdate.setEmail(creator.getEmail());
        if (!voteStarted) {
            ImmutableMap choicesExist = Maps.uniqueIndex((Iterable)pollToUpdate.getChoice(), (Function)PollenServiceFunctions.newTopiaIdExtractor());
            HashSet choicesAdded = Sets.newHashSet();
            for (Choice choice : poll.getChoice()) {
                String choiceId = this.saveChoice(pollToUpdate, choice);
                choicesAdded.add(choiceId);
            }
            Map choicesToDelete = Maps.filterKeys((Map)choicesExist, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)choicesAdded)));
            for (Choice choice : choicesToDelete.values()) {
                pollToUpdate.removeChoice(choice);
            }
        }
        for (PreventRule preventRule : poll.getPreventRule()) {
            this.savePreventRule(pollToUpdate, preventRule);
        }
        if (!voteStarted) {
            EmailService emailService = this.newService(EmailService.class);
            pollToUpdate.clearVotingList();
            try {
                for (VotingList votingList : poll.getVotingList()) {
                    this.saveVotingList(pollToUpdate, votingList, emailService);
                }
            }
            catch (TopiaException e) {
                throw new PollenTechnicalException("Can't save votingLists", (Throwable)e);
            }
        }
        this.commitTransaction("Could not update poll [" + poll.getTopiaId() + "]");
    }

    public PollUrl getPollVoteUrl(Poll poll, boolean moderate) {
        URL applicationUrl = this.serviceContext.getApplicationURL();
        String baseUrl = applicationUrl + "/poll/votefor/";
        PollUri pollUri = PollUri.newPollUri(poll.getPollId());
        if (moderate) {
            String creatorId = poll.getCreator().getAccountId();
            pollUri.setAccountId(creatorId);
        }
        PollUrl result = PollUrl.newPollUrl(baseUrl, pollUri);
        return result;
    }

    public PollUrl getPollEditUrl(Poll poll) {
        URL applicationUrl = this.serviceContext.getApplicationURL();
        String baseUrl = applicationUrl + "/poll/modification/";
        String creatorId = poll.getCreator().getAccountId();
        PollUri pollUri = PollUri.newPollUri(poll.getPollId(), creatorId);
        PollUrl result = PollUrl.newPollUrl(baseUrl, pollUri);
        return result;
    }

    public PollUrl getPollResultUrl(Poll poll) {
        URL applicationUrl = this.serviceContext.getApplicationURL();
        String baseUrl = applicationUrl + "/poll/results/";
        PollUri pollUri = PollUri.newPollUri(poll.getPollId());
        if (!poll.isPublicResults()) {
            String creatorId = poll.getCreator().getAccountId();
            pollUri.setAccountId(creatorId);
        }
        PollUrl result = PollUrl.newPollUrl(baseUrl, pollUri);
        return result;
    }

    public List<Poll> getPolls(TopiaFilterPagerUtil.FilterPagerBean pager) {
        Preconditions.checkNotNull((Object)pager);
        try {
            PollDAO dao = (PollDAO)this.getDAO(Poll.class);
            List result = dao.getPolls(pager);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain polls", (Throwable)e);
        }
    }

    public List<Poll> getCreatedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount user) {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        try {
            PollDAO dao = (PollDAO)this.getDAO(Poll.class);
            List result = dao.getCreatedPolls(pager, user);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain created polls", (Throwable)e);
        }
    }

    public Map<Poll, PollAccount> getInvitedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount user) {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        UserService userService = this.newService(UserService.class);
        UserAccount userToUse = userService.getEntityById(UserAccount.class, user.getTopiaId());
        Preconditions.checkNotNull((Object)userToUse);
        try {
            PollDAO pollDao = (PollDAO)this.getDAO(Poll.class);
            Map result = pollDao.getInvitedPolls(pager, userToUse);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain invited polls", (Throwable)e);
        }
    }

    public Map<Poll, PollAccount> getParticipatedPolls(TopiaFilterPagerUtil.FilterPagerBean pager, UserAccount user) {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        UserService userService = this.newService(UserService.class);
        UserAccount userToUse = userService.getEntityById(UserAccount.class, user.getTopiaId());
        Preconditions.checkNotNull((Object)userToUse);
        try {
            PollDAO pollDao = (PollDAO)this.getDAO(Poll.class);
            Map result = pollDao.getParticipatedPolls(pager, userToUse);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain running polls", (Throwable)e);
        }
    }

    public List<Poll> getRunningPolls(boolean withEndDate) {
        try {
            PollDAO dao = (PollDAO)this.getDAO(Poll.class);
            List results = dao.getRunningPolls(withEndDate);
            return results;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not obtain running polls", (Throwable)e);
        }
    }

    public Poll getPollByPollId(String pollId) {
        Preconditions.checkNotNull((Object)pollId);
        try {
            PollDAO dao = (PollDAO)this.getDAO(Poll.class);
            Poll result = dao.findByPollId(pollId);
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not find poll with pollId '" + pollId + "'", (Throwable)e);
        }
    }

    public PollAccount getPollAccountEditable(String accountId, UserAccount userAccount, Poll poll) throws PollAccountNotFound {
        PollAccount result = null;
        if (StringUtils.isNotEmpty((CharSequence)accountId)) {
            PollAccount pollAccountLoaded = this.getPollAccountByAccountId(accountId);
            result = this.copyPollAccount(pollAccountLoaded);
            if (userAccount != null && result.getUserAccount() == null) {
                result.setUserAccount(userAccount);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Attach User '%s' [%s] to the existing Account [%s]", userAccount.getDisplayName(), userAccount.getTopiaId(), accountId));
                }
            }
        } else {
            if (userAccount != null) {
                PollAccount pollAccountLoaded;
                PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
                try {
                    pollAccountLoaded = pollAccountDAO.findByPollVoteUser(poll, userAccount);
                }
                catch (TopiaException e) {
                    throw new PollenTechnicalException((Throwable)e);
                }
                if (pollAccountLoaded != null) {
                    result = this.copyPollAccount(pollAccountLoaded);
                }
                if (log.isDebugEnabled()) {
                    String account = result == null ? "null" : result.getVotingId() + " [" + result.getAccountId() + "]";
                    log.debug((Object)String.format("PollAccount found from user '%s' = %s", userAccount.getDisplayName(), account));
                }
            }
            if (result == null) {
                result = this.getNewPollAccount(userAccount);
            }
        }
        return result;
    }

    protected PollAccount copyPollAccount(PollAccount source) {
        PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
        PollAccount result = (PollAccount)this.newInstance(dao);
        PollenBinderHelper.copy((String)"", (TopiaEntity)source, (TopiaEntity)result, (boolean)true);
        result.setUserAccount(source.getUserAccount());
        return result;
    }

    public PollAccount getNewPollAccount(UserAccount userAccount) {
        PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
        PollAccount result = (PollAccount)this.newInstance(dao);
        result.setAccountId(this.serviceContext.createPollenUrlId());
        String votingId = userAccount != null ? userAccount.getDisplayName() : "";
        result.setVotingId(votingId);
        result.setUserAccount(userAccount);
        return result;
    }

    public PollAccount getPollAccountByAccountId(String accountId) throws PollAccountNotFound {
        try {
            PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
            PollAccount result = dao.findByAccountId(accountId);
            if (result == null) {
                throw new PollAccountNotFound();
            }
            return result;
        }
        catch (TopiaException e) {
            throw new PollenTechnicalException("Could not botain account with this id", (Throwable)e);
        }
    }

    public void deletePoll(String pollId, UserAccount userAccount, String accountId) throws PollNotFoundException, PollAccountNotFound, UnauthorizedPollAccessException {
        PollAccount account;
        Preconditions.checkNotNull((Object)pollId);
        Preconditions.checkNotNull((Object)accountId);
        Poll poll = this.getPollByPollId(pollId);
        if (poll == null) {
            throw new PollNotFoundException();
        }
        if ((userAccount == null || userAccount.isAdministrator()) && !(account = this.getPollAccountByAccountId(accountId)).getAccountId().equals(poll.getCreator().getAccountId())) {
            throw new UnauthorizedPollAccessException();
        }
        PollDAO dao = (PollDAO)this.getDAO(Poll.class);
        this.delete(dao, poll);
        this.commitTransaction("Could not delete poll" + poll.getTitle());
    }

    public void closePoll(String pollId, UserAccount userAccount, String accountId) throws PollNotFoundException, PollAccountNotFound, UnauthorizedPollAccessException {
        PollAccount account;
        Preconditions.checkNotNull((Object)pollId);
        Preconditions.checkNotNull((Object)accountId);
        Poll poll = this.getPollByPollId(pollId);
        if (poll == null) {
            throw new PollNotFoundException();
        }
        if ((userAccount == null || userAccount.isAdministrator()) && !(account = this.getPollAccountByAccountId(accountId)).getAccountId().equals(poll.getCreator().getAccountId())) {
            throw new UnauthorizedPollAccessException();
        }
        if (!poll.isChoiceEmpty()) {
            for (Choice choice : poll.getChoice()) {
                choice.setValidate(true);
            }
        }
        Date now = new Date();
        if (poll.getEndDate() == null || now.before(poll.getEndDate())) {
            poll.setEndDate(now);
        }
        poll.setClosed(true);
        this.commitTransaction("Could not close poll " + poll.getTitle());
    }

    public Choice getNewChoice(ChoiceType choiceType) {
        ChoiceImpl result;
        switch (choiceType) {
            case DATE: {
                result = new PollDateChoice();
                break;
            }
            case IMAGE: {
                result = new PollImageChoice();
                break;
            }
            default: {
                ChoiceDAO dao = (ChoiceDAO)this.getDAO(Choice.class);
                result = (Choice)this.newInstance(dao);
            }
        }
        return result;
    }

    public void createChoice(String pollId, Choice choice) throws PollNotFoundException {
        Preconditions.checkNotNull((Object)pollId);
        Preconditions.checkNotNull((Object)choice);
        Poll poll = this.getPollByPollId(pollId);
        if (poll == null) {
            throw new PollNotFoundException();
        }
        this.saveChoice(poll, choice);
        this.commitTransaction("Can't create new choice [" + poll.getChoiceType() + "] for poll '" + pollId + "'");
    }

    protected String saveChoice(Poll poll, Choice choice) {
        Choice choiceLoaded;
        ChoiceType choiceType = poll.getChoiceType();
        ChoiceDAO dao = (ChoiceDAO)this.getDAO(Choice.class);
        if (choice.getTopiaId() == null) {
            choiceLoaded = (Choice)this.create(dao);
            poll.addChoice(choiceLoaded);
        } else {
            choiceLoaded = poll.getChoiceByTopiaId(choice.getTopiaId());
        }
        if (choiceType == ChoiceType.IMAGE) {
            PollImageChoice imageChoice = (PollImageChoice)choice;
            imageChoice.toChoice(choiceLoaded);
            try {
                this.saveImages(poll, imageChoice);
            }
            catch (IOException e) {
                throw new PollenTechnicalException("Could not create image choice", (Throwable)e);
            }
        } else if (choiceType == ChoiceType.DATE) {
            PollDateChoice dateChoice = (PollDateChoice)choice;
            dateChoice.toChoice(choiceLoaded);
        } else {
            choiceLoaded.setDescription(choice.getDescription());
            choiceLoaded.setValidate(choice.isValidate());
            choiceLoaded.setName(choice.getName());
        }
        return choiceLoaded.getTopiaId();
    }

    public void deleteChoice(String pollId, String choiceId) throws PollNotFoundException, PollChoiceNotFoundException {
        Poll poll = this.getPollByPollId(pollId);
        if (poll == null) {
            throw new PollNotFoundException();
        }
        Choice choice = poll.getChoiceByTopiaId(choiceId);
        if (choice == null) {
            throw new PollChoiceNotFoundException();
        }
        ChoiceDAO dao = (ChoiceDAO)this.getDAO(Choice.class);
        poll.removeChoice(choice);
        this.delete(dao, choice);
        this.commitTransaction("Could not delete choice " + choice.getName());
    }

    public void checkPoll(PollUri uri) throws PollNotFoundException {
        String pollId = uri.getPollId();
        Poll poll = this.getPollByPollId(pollId);
        if (poll == null) {
            throw new PollNotFoundException();
        }
    }

    public void checkPollResult(PollUri uri) throws PollNotFoundException, UnauthorizedPollAccessException {
        String pollId = uri.getPollId();
        Poll poll = this.getPollByPollId(pollId);
        if (poll == null) {
            throw new PollNotFoundException();
        }
        if (!poll.isPublicResults()) {
            throw new UnauthorizedPollAccessException();
        }
    }

    public void checkPollAccount(PollUri uri) throws PollNotFoundException, UnauthorizedPollAccessException {
        block9: {
            String pollId = uri.getPollId();
            String accountId = uri.getAccountId();
            Poll poll = this.getPollByPollId(pollId);
            if (poll == null) {
                throw new PollNotFoundException();
            }
            PollAccountDAO dao = (PollAccountDAO)this.getDAO(PollAccount.class);
            if (poll.getPollType() != PollType.FREE) {
                try {
                    PollAccount result = dao.getRestrictedPollAccount(pollId, accountId);
                    if (result == null) {
                        throw new UnauthorizedPollAccessException();
                    }
                    break block9;
                }
                catch (TopiaException e) {
                    throw new PollenTechnicalException("Could not obtain restricted pollAccount", (Throwable)e);
                }
            }
            if (accountId != null) {
                try {
                    if (!dao.existsByPollVoteAccountId(pollId, accountId)) {
                        throw new UnauthorizedPollAccessException();
                    }
                }
                catch (TopiaException e) {
                    throw new PollenTechnicalException("Could not check pollAccount existence from poll '" + pollId + "' and account '" + accountId + "'", (Throwable)e);
                }
            }
        }
    }

    public void checkPollCreator(PollUri uri) throws PollNotFoundException, UnauthorizedPollAccessException {
        String pollId = uri.getPollId();
        String accountId = uri.getAccountId();
        Poll poll = this.getPollByPollId(pollId);
        if (poll == null) {
            throw new PollNotFoundException();
        }
        String creatorId = poll.getCreator().getAccountId();
        if (!creatorId.equals(accountId)) {
            throw new UnauthorizedPollAccessException();
        }
    }

    public File getPollChoiceImageFile(String pollId, String choiceId, boolean thumb) {
        File imageDirectory = this.getConfiguration().getImageDirectory();
        File pollDirectory = new File(imageDirectory, pollId);
        if (thumb) {
            choiceId = THUMB_PREFIX + choiceId;
        }
        File result = new File(pollDirectory, choiceId);
        return result;
    }

    public void saveImages(Poll poll, PollImageChoice choice) throws IOException {
        String location = choice.getLocation();
        String pollId = poll.getPollId();
        String name = choice.getName();
        File pollChoiceImage = this.getPollChoiceImageFile(pollId, name, false);
        File pollChoiceImageThumb = this.getPollChoiceImageFile(pollId, name, true);
        FileUtils.copyFile((File)new File(location), (File)pollChoiceImage);
        PollService.createThumbnail(pollChoiceImage, pollChoiceImageThumb, 100);
    }

    public void addVoteToPoll(Poll poll, Vote vote) {
        String pollId = poll.getTopiaId();
        String voteId = vote.getTopiaId();
        Poll pollToUpdate = this.getEntityById(Poll.class, pollId);
        Vote voteToAdd = this.getEntityById(Vote.class, voteId);
        pollToUpdate.addVote(voteToAdd);
        if (PollType.FREE != poll.getPollType()) {
            PersonToList personToList = pollToUpdate.getPersonToListByVote(voteToAdd);
            personToList.setHasVoted(true);
        }
        this.commitTransaction("Can't add the vote [" + voteId + "] to the poll [" + pollId + "]");
        PreventRuleService preventRuleService = this.newService(PreventRuleService.class);
        PollUrl pollVoteUrl = this.getPollVoteUrl(pollToUpdate, false);
        PollUrl modifUrl = this.getPollEditUrl(pollToUpdate);
        preventRuleService.onVoteAdded(poll, pollVoteUrl, modifUrl);
    }

    public PersonToList getNewPersonToList(PollAccount pollAccount) {
        PersonToList result = (PersonToList)this.newInstance(this.getDAO(PersonToList.class));
        result.setWeight(1.0);
        PollAccount pollAccount2 = (PollAccount)this.newInstance(this.getDAO(PollAccount.class));
        String accountId = this.serviceContext.createPollenUrlId();
        pollAccount2.setAccountId(accountId);
        result.setPollAccount(pollAccount2);
        if (pollAccount != null) {
            pollAccount2.setComment(pollAccount.getComment());
            pollAccount2.setEmail(pollAccount.getEmail());
            pollAccount2.setUserAccount(pollAccount.getUserAccount());
            pollAccount2.setVotingId(pollAccount.getVotingId());
        }
        return result;
    }

    protected void saveVotingList(Poll poll, VotingList votingList, EmailService emailService) throws TopiaException {
        VotingList result;
        VotingListDAO votingListDAO = (VotingListDAO)this.getDAO(VotingList.class);
        PersonToListDAO personToListDAO = (PersonToListDAO)this.getDAO(PersonToList.class);
        PollAccountDAO pollAccountDAO = (PollAccountDAO)this.getDAO(PollAccount.class);
        if (votingList.getTopiaId() == null) {
            result = (VotingList)this.create(votingListDAO);
            poll.addVotingList(result);
        } else {
            result = poll.getVotingListByTopiaId(votingList.getTopiaId());
            result.setPoll(poll);
        }
        result.setName(votingList.getName());
        result.setWeight(votingList.getWeight());
        PollUrl voteURL = this.getPollVoteUrl(poll, false);
        ArrayList personToListsUpdated = Lists.newArrayList();
        for (PersonToList personToList : votingList.getPollAccountPersonToList()) {
            PollAccount pollAccountLoaded;
            PersonToList personToListLoaded;
            PollAccount pollAccount = personToList.getPollAccount();
            if (personToList.getTopiaId() == null) {
                personToListLoaded = (PersonToList)this.create(personToListDAO);
                personToListLoaded.setVotingList(result);
                String accountId = pollAccount.getAccountId();
                if (accountId == null) {
                    accountId = this.serviceContext.createPollenUrlId();
                }
                if ((pollAccountLoaded = pollAccountDAO.findByAccountId(accountId)) == null) {
                    pollAccountLoaded = (PollAccount)this.create(pollAccountDAO);
                    pollAccountLoaded.setAccountId(accountId);
                }
            } else {
                personToListLoaded = this.getEntityById(PersonToList.class, personToList.getTopiaId());
                pollAccountLoaded = personToListLoaded.getPollAccount();
            }
            personToListsUpdated.add(personToListLoaded);
            personToListLoaded.setWeight(personToList.getWeight());
            pollAccountLoaded.setVotingId(pollAccount.getVotingId());
            boolean emailChanged = !Objects.equal((Object)pollAccountLoaded.getEmail(), (Object)pollAccount.getEmail());
            pollAccountLoaded.setEmail(pollAccount.getEmail());
            if (emailService != null && emailChanged) {
                emailService.onRestrictedPersonAdded(poll, pollAccountLoaded, voteURL);
            }
            PollAccount pollAccountUpdated = this.update(pollAccountDAO, pollAccountLoaded);
            personToListLoaded.setPollAccount(pollAccountUpdated);
        }
        result.setPollAccountPersonToList((List)personToListsUpdated);
    }

    protected void savePreventRule(Poll poll, PreventRule preventRule) {
        PreventRuleDAO preventRuleDAO = (PreventRuleDAO)this.getDAO(PreventRule.class);
        PreventRule preventRuleLoaded = poll.getPreventRuleByScope(preventRule.getScope());
        if (preventRuleLoaded == null) {
            preventRuleLoaded = (PreventRule)this.create(preventRuleDAO);
            poll.addPreventRule(preventRuleLoaded);
            preventRuleLoaded.setScope(preventRule.getScope());
            preventRuleLoaded.setActive(true);
        }
        preventRuleLoaded.setMethod(preventRule.getMethod());
        preventRuleLoaded.setOneTime(preventRule.isOneTime());
        preventRuleLoaded.setRepeated(preventRule.isRepeated());
        preventRuleLoaded.setSensibility(preventRule.getSensibility());
    }

    protected static void createThumbnail(File img, File thumbCopied, int width) throws IOException {
        ImageIcon ii = new ImageIcon(img.getAbsolutePath());
        Image image = ii.getImage();
        double imageRatio = (double)image.getHeight(null) / (double)image.getWidth(null);
        int height = (int)((double)width * imageRatio);
        BufferedImage thumbImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, width, height, null);
        ImageIO.write((RenderedImage)thumbImage, "jpg", thumbCopied);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Thumbnail created: " + thumbCopied.getName() + " (size=" + thumbCopied.length() + ")"));
        }
    }
}

