/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Set;
import org.chorem.pollen.PollenFunctions;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.votecounting.VoteCounting;
import org.chorem.pollen.votecounting.VoteCountingFactory;
import org.chorem.pollen.votecounting.model.GroupOfVoter;
import org.chorem.pollen.votecounting.model.GroupOfVoterBuilder;
import org.chorem.pollen.votecounting.model.SimpleVoterBuilder;
import org.chorem.pollen.votecounting.model.VoterBuilder;

public class Polls {
    public static GroupOfVoter toSimpleVotersGroup(Poll poll) {
        Preconditions.checkNotNull((Object)poll);
        SimpleVoterBuilder builder = new SimpleVoterBuilder();
        for (Vote vote : poll.getVote()) {
            Polls.fillSimpleVoter((VoterBuilder)builder, vote);
        }
        Set voter = builder.getVoters();
        GroupOfVoter result = GroupOfVoter.newVoter(null, (double)1.0, (Set)voter);
        return result;
    }

    public static GroupOfVoter toGroupOfVoters(Poll poll) {
        Preconditions.checkNotNull((Object)poll);
        Preconditions.checkArgument((boolean)poll.isPollGroup(), (Object)"Can only use this method for a group poll");
        GroupOfVoterBuilder builder = new GroupOfVoterBuilder();
        ImmutableMap voteByPollAccount = Maps.uniqueIndex(poll.getVote(), PollenFunctions.VOTE_TO_POLL_ACCOUNT);
        for (VotingList votingList : poll.getVotingList()) {
            builder.newGroupVoter(votingList.getTopiaId(), votingList.getWeight());
            for (PersonToList personToList : votingList.getPollAccountPersonToList()) {
                PollAccount voterAccount = personToList.getPollAccount();
                Vote vote = (Vote)voteByPollAccount.get(voterAccount);
                if (vote == null) continue;
                Polls.fillSimpleVoter((VoterBuilder)builder, vote);
            }
        }
        Set voter = builder.getVoters();
        GroupOfVoter result = GroupOfVoter.newVoter(null, (double)1.0, (Set)voter);
        return result;
    }

    public static VoteCounting getVoteCounting(VoteCountingFactory factory, Poll poll) {
        Preconditions.checkNotNull((Object)factory);
        Preconditions.checkNotNull((Object)poll);
        int id = poll.getVoteCountingType();
        VoteCounting result = factory.getVoteCounting(id);
        Preconditions.checkNotNull((Object)result, (Object)("Could not find vote counting for id " + id));
        return result;
    }

    protected static void fillSimpleVoter(VoterBuilder builder, Vote vote) {
        builder.newVoter(vote.getPollAccount().getAccountId(), vote.getWeight());
        if (!vote.isChoiceVoteToChoiceEmpty()) {
            for (VoteToChoice voteToChoice : vote.getChoiceVoteToChoice()) {
                builder.addVoteForChoice(voteToChoice.getChoice().getTopiaId(), Double.valueOf(voteToChoice.getVoteValue().intValue()));
            }
        }
    }
}

