/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.services;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.converters.DataUserConverter;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.services.ServiceUser;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;

public class ServiceUserImpl
implements ServiceUser {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private UserAccountDAO userDAO = null;
    private DataUserConverter converter = new DataUserConverter();
    private static final Log log = LogFactory.getLog(ServiceUserImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createUser(UserDTO user, String password) {
        TopiaContext transaction = null;
        String topiaId = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            if (this.userDAO.findByLogin(user.getLogin()) != null || !"".equals(user.getEmail()) && this.userDAO.findByEmail(user.getEmail()) != null) {
                String string = null;
                return string;
            }
            UserAccount userEntity = (UserAccount)this.userDAO.create(new Object[0]);
            this.converter.populateUserEntity(user, userEntity, password);
            topiaId = userEntity.getTopiaId();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity created: " + topiaId));
            }
            String string = topiaId;
            return string;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            String string = null;
            return string;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(String login) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            Object userEntity = this.userDAO.findByLogin(login);
            this.userDAO.delete(userEntity);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + userEntity.getTopiaId()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteUser(UserDTO user) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount userEntity = (UserAccount)this.userDAO.findByTopiaId(user.getId());
            this.userDAO.delete(userEntity);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity deleted: " + userEntity.getTopiaId()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserDTO findUserById(String userId) {
        TopiaContext transaction = null;
        UserDTO result = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount userEntity = (UserAccount)this.userDAO.findByTopiaId(userId);
            if (userEntity != null) {
                this.converter.setTransaction(transaction);
                result = this.converter.createUserDTO(userEntity);
            }
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            UserDTO userDTO = result;
            return userDTO;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            UserDTO userDTO = null;
            return userDTO;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserDTO> selectUsers(Map<String, Object> properties) {
        TopiaContext transaction = null;
        List<UserDTO> results = null;
        List userEntities = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            if (properties == null) {
                userEntities = this.userDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les utilisateurs ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                userEntities = this.userDAO.findAllByProperties(properties);
            }
            results = this.converter.createUserDTOs(userEntities);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            List<UserDTO> list = results;
            return list;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            List<UserDTO> list = null;
            return list;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateUser(UserDTO user) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount userEntity = (UserAccount)this.userDAO.findByTopiaId(user.getId());
            this.converter.setTransaction(transaction);
            this.converter.populateUserEntity(user, userEntity);
            this.userDAO.update(userEntity);
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + user.getId()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePasswordUser(UserDTO user, String newPassword) {
        TopiaContext transaction = null;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            UserAccount userEntity = (UserAccount)this.userDAO.findByTopiaId(user.getId());
            userEntity.setPassword(newPassword);
            userEntity.update();
            transaction.commitTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity updated: " + user.getId()));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = false;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserLoginExisting(String login) {
        TopiaContext transaction = null;
        boolean userExists = true;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            if (this.userDAO.findByLogin(login) == null) {
                userExists = false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity exists for the login " + login + ": " + userExists));
            }
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = true;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
        return userExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserEmailExisting(String email) {
        TopiaContext transaction = null;
        boolean userExists = true;
        try {
            transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(transaction);
            if (this.userDAO.findByEmail(email) == null) {
                userExists = false;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entity exists for the email " + email + ": " + userExists));
            }
        }
        catch (Exception e) {
            ContextUtil.doCatch(e, transaction);
            boolean bl = true;
            return bl;
        }
        finally {
            ContextUtil.doFinally(transaction);
        }
        return userExists;
    }
}

