/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chorem.pollen.business.converters.DataConverter;
import org.chorem.pollen.business.dto.PreventRuleDTO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.PreventRule;
import org.nuiton.topia.TopiaException;

public class DataPreventRuleConverter
extends DataConverter {
    public void populatePreventRuleEntity(PreventRuleDTO preventRuleDTO, PreventRule ePreventRule) throws TopiaException {
        ePreventRule.setScope(preventRuleDTO.getScope());
        ePreventRule.setSensibility(preventRuleDTO.getSensibility());
        ePreventRule.setActive(preventRuleDTO.isActive());
        ePreventRule.setOneTime(preventRuleDTO.isOneTime());
        ePreventRule.setRepeated(preventRuleDTO.isRepeated());
        ePreventRule.setMethod(preventRuleDTO.getMethod());
        if (preventRuleDTO.getPollId().length() > 0) {
            PollDAO pollDAO = PollenModelDAOHelper.getPollDAO(this.transaction);
            Poll pollEntity = (Poll)pollDAO.findByTopiaId(preventRuleDTO.getPollId());
            ePreventRule.setPoll(pollEntity);
        }
    }

    public PreventRuleDTO createPreventRuleDTO(PreventRule preventRule) {
        PreventRuleDTO preventRuleDTO = new PreventRuleDTO();
        preventRuleDTO.setId(preventRule.getTopiaId());
        preventRuleDTO.setScope(preventRule.getScope());
        preventRuleDTO.setSensibility(preventRule.getSensibility());
        preventRuleDTO.setActive(preventRule.getActive());
        preventRuleDTO.setOneTime(preventRule.getOneTime());
        preventRuleDTO.setRepeated(preventRule.getRepeated());
        preventRuleDTO.setMethod(preventRule.getMethod());
        if (preventRule.getPoll() != null) {
            preventRuleDTO.setPollId(preventRule.getPoll().getTopiaId());
        }
        return preventRuleDTO;
    }

    public List<PreventRuleDTO> createPreventRuleDTOs(Collection<PreventRule> cPreventRules) {
        ArrayList<PreventRuleDTO> results = new ArrayList<PreventRuleDTO>();
        for (PreventRule r : cPreventRules) {
            PreventRuleDTO dto = this.createPreventRuleDTO(r);
            results.add(dto);
        }
        return results;
    }
}

