/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité Comment.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class CommentDAOAbstract<E extends Comment> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)Comment.class;
    }

    public void delete(E entity) throws TopiaException {
        
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut text
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * text le paramètre
     * @param v la valeur que doit avoir text
     * @return un element ou null
     */
    public E findByText(java.lang.String v) throws TopiaException {
        E result = findByProperty("text", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * text le paramètre
     * @param v la valeur que doit avoir text
     * @return une liste
     */
    public List<E> findAllByText(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("text", v);
        return result;
    }
    /**
     * Recherche sur l'attribut postDate
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * postDate le paramètre
     * @param v la valeur que doit avoir postDate
     * @return un element ou null
     */
    public E findByPostDate(java.util.Date v) throws TopiaException {
        E result = findByProperty("postDate", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * postDate le paramètre
     * @param v la valeur que doit avoir postDate
     * @return une liste
     */
    public List<E> findAllByPostDate(java.util.Date v) throws TopiaException {
        List<E> result = findAllByProperty("postDate", v);
        return result;
    }
    /**
     * Recherche sur l'attribut poll
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * poll le paramètre
     * @param v la valeur que doit avoir poll
     * @return un element ou null
     */
    public E findByPoll(org.chorem.pollen.business.persistence.Poll v) throws TopiaException {
        E result = findByProperty("poll", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * poll le paramètre
     * @param v la valeur que doit avoir poll
     * @return une liste
     */
    public List<E> findAllByPoll(org.chorem.pollen.business.persistence.Poll v) throws TopiaException {
        List<E> result = findAllByProperty("poll", v);
        return result;
    }
    /**
     * Recherche sur l'attribut pollAccount
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * pollAccount le paramètre
     * @param v la valeur que doit avoir pollAccount
     * @return un element ou null
     */
    public E findByPollAccount(org.chorem.pollen.business.persistence.PollAccount v) throws TopiaException {
        E result = findByProperty("pollAccount", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * pollAccount le paramètre
     * @param v la valeur que doit avoir pollAccount
     * @return une liste
     */
    public List<E> findAllByPollAccount(org.chorem.pollen.business.persistence.PollAccount v) throws TopiaException {
        List<E> result = findAllByProperty("pollAccount", v);
        return result;
    }

} // CommentDAOAbstract
