/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServiceResults;
import org.chorem.pollen.business.converters.DataResultConverter;
import org.chorem.pollen.business.converters.EntityToVoteCountingDTO;
import org.chorem.pollen.business.converters.EnumController;
import org.chorem.pollen.business.dto.ResultDTO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.utils.ContextUtil;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.votecounting.business.VoteCounting;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceResultsImpl
implements ServiceResults {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private static final Log log = LogFactory.getLog(ServiceResultsImpl.class);

    @Override
    public List<ResultDTO> getAllResults(String pollId) {
        return this.getResults(pollId, null, false, false);
    }

    @Override
    public List<ResultDTO> getResultsByVoteCounting(String pollId, VoteCountingType voteCounting) {
        return this.getResults(pollId, voteCounting, false, false);
    }

    @Override
    public List<ResultDTO> getGroupResults(String pollId) {
        return this.getResults(pollId, null, true, true);
    }

    @Override
    public List<ResultDTO> getNormalResults(String pollId) {
        return this.getResults(pollId, null, true, false);
    }

    private List<ResultDTO> getResults(String pollId, VoteCountingType voteCounting, boolean byGroup, boolean groupOnly) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            PollDAO daoPoll = PollenModelDAOHelper.getPollDAO(this.transaction);
            Object ePoll = daoPoll.findByPollId(pollId);
            DataResultConverter converter = new DataResultConverter(this.transaction);
            if (log.isDebugEnabled()) {
                log.debug((Object)(ePoll.getPollId() + " (" + voteCounting + ") has results: " + this.hasResults((Poll)ePoll, voteCounting)));
            }
            PollDTO dto = EntityToVoteCountingDTO.createPollDTOForVoteCounting(ePoll);
            if (voteCounting != null) {
                dto.setTypeVoteCounting(voteCounting);
            }
            VoteCounting service = new VoteCounting();
            VoteCountingResultDTO result = null;
            result = EnumController.isGroupType(ePoll) ? service.executeGroupCounting(dto) : service.executeVoteCounting(dto);
            ePoll.clearResult();
            converter.populateResultEntities(result);
            this.transaction.commitTransaction();
            List<ResultDTO> list = converter.createResultDTOs((Poll)ePoll);
            this.transaction.closeContext();
            if (voteCounting != null) {
                Iterator<ResultDTO> it = list.iterator();
                while (it.hasNext()) {
                    ResultDTO curr = it.next();
                    if (voteCounting != null && curr.getVoteCounting() != voteCounting) {
                        it.remove();
                    }
                    if (!byGroup) continue;
                    if (groupOnly && !curr.isByGroup()) {
                        it.remove();
                    } else if (!groupOnly && curr.isByGroup()) {
                        it.remove();
                    }
                    if (curr.getVoteCounting() == EnumController.getVoteCountingType(ePoll)) continue;
                    it.remove();
                }
            }
            return list;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public String exportPoll(String pollId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String importPoll(String filePath) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean hasResults(Poll ePoll, VoteCountingType type) {
        List<Result> results = ePoll.getResult();
        if (results == null || results.isEmpty()) {
            return false;
        }
        if (!results.isEmpty() && type == null) {
            return true;
        }
        for (Result curr : results) {
            if (EnumController.getVoteCountingType(curr) != type) continue;
            return true;
        }
        return false;
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

