/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service.utils;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumberUtil {
    private static final Log log = LogFactory.getLog(NumberUtil.class);
    public static NumberFormat numberFormat;
    public static final String format = "%0$10.2f";

    public static NumberFormat getNumberFormat() {
        if (numberFormat == null) {
            numberFormat = NumberFormat.getNumberInstance(Locale.FRENCH);
        }
        return numberFormat;
    }

    public Double formatNumber(String amount) {
        Double numberDouble;
        try {
            Number number = NumberUtil.getNumberFormat().parse(amount);
            numberDouble = number.doubleValue();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return numberDouble;
    }

    public String format(double number) {
        return String.format(Locale.FRENCH, format, number).trim();
    }

    public String format(String amount) {
        return this.format(this.formatNumber(amount));
    }
}

