/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.callao.service;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.service.AccountServiceImpl;
import org.chorem.callao.service.EntryServiceImpl;
import org.chorem.callao.service.JournalServiceImpl;
import org.chorem.callao.service.PeriodServiceImpl;
import org.chorem.callao.service.TimeSpanServiceImpl;
import org.chorem.callao.service.TransactionServiceImpl;
import org.chorem.callao.service.dto.AccountDTO;
import org.chorem.callao.service.dto.EntryDTO;
import org.chorem.callao.service.dto.JournalDTO;
import org.chorem.callao.service.dto.PeriodDTO;
import org.chorem.callao.service.dto.TimeSpanDTO;
import org.chorem.callao.service.dto.TransactionDTO;
import org.chorem.callao.service.utils.DateUtil;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.nuiton.topia.TopiaContext;

public class FilesServiceImpl {
    private static final Log log = LogFactory.getLog(FilesServiceImpl.class);
    static Element racine = new Element("Callao");
    static Document document = new Document(racine);
    private static DateUtil dateUtil = new DateUtil();
    private AccountServiceImpl accountServiceImpl = new AccountServiceImpl();
    private EntryServiceImpl entryServiceImpl = new EntryServiceImpl();
    private JournalServiceImpl journalServiceImpl = new JournalServiceImpl();
    private PeriodServiceImpl periodServiceImpl = new PeriodServiceImpl();
    private TimeSpanServiceImpl timeSpanServiceImpl = new TimeSpanServiceImpl();
    private TransactionServiceImpl transactionServiceImpl = new TransactionServiceImpl();

    public String exportDatas(String nameFile) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Save file XML : ");
        }
        Element info = new Element("informations");
        racine.addContent((Content)info);
        Attribute date = new Attribute("date", new Date().toString());
        info.setAttribute(date);
        Attribute user = new Attribute("user", "Name user");
        info.setAttribute(user);
        Attribute company = new Attribute("company", "Name company");
        info.setAttribute(company);
        Element save = new Element("save");
        racine.addContent((Content)save);
        Element periods = new Element("periods");
        Element timeSpans = new Element("timespans");
        save.addContent((Content)periods);
        save.addContent((Content)timeSpans);
        List<PeriodDTO> listPeriodDTO = this.periodServiceImpl.getAllPeriod();
        for (PeriodDTO periodDTO : listPeriodDTO) {
            Attribute locked;
            Element period = new Element("period");
            periods.addContent((Content)period);
            Attribute id = new Attribute("id", periodDTO.getId());
            period.setAttribute(id);
            String[] dateTab = dateUtil.arrayDate(periodDTO.getBeginPeriod());
            Attribute beginYear = new Attribute("beginYear", dateTab[0]);
            period.setAttribute(beginYear);
            Attribute beginMonth = new Attribute("beginMonth", dateTab[1]);
            period.setAttribute(beginMonth);
            Attribute beginDay = new Attribute("beginDay", dateTab[2]);
            period.setAttribute(beginDay);
            dateTab = dateUtil.arrayDate(periodDTO.getEndPeriod());
            Attribute endYear = new Attribute("endYear", dateTab[0]);
            period.setAttribute(endYear);
            Attribute endMonth = new Attribute("endMonth", dateTab[1]);
            period.setAttribute(endMonth);
            Attribute endDay = new Attribute("endDay", dateTab[2]);
            period.setAttribute(endDay);
            if (periodDTO.isLocked()) {
                locked = new Attribute("locked", "true");
                period.setAttribute(locked);
            } else {
                locked = new Attribute("locked", "false");
                period.setAttribute(locked);
            }
            List<TimeSpanDTO> listTimeSpanDTO = periodDTO.getListTimeSpan();
            for (TimeSpanDTO timeSpanDTO : listTimeSpanDTO) {
                Attribute locked2;
                Element timeSpan = new Element("timespan");
                timeSpans.addContent((Content)timeSpan);
                Attribute idTimeSpan = new Attribute("id", timeSpanDTO.getId());
                timeSpan.setAttribute(idTimeSpan);
                Attribute idPeriod = new Attribute("idPeriod", periodDTO.getId());
                timeSpan.setAttribute(idPeriod);
                dateTab = dateUtil.arrayDate(timeSpanDTO.getBeginTimeSpan());
                Attribute beginYearTimeSpan = new Attribute("beginYear", dateTab[0]);
                timeSpan.setAttribute(beginYearTimeSpan);
                Attribute beginMonthTimeSpan = new Attribute("beginMonth", dateTab[1]);
                timeSpan.setAttribute(beginMonthTimeSpan);
                Attribute beginDayTimeSpan = new Attribute("beginDay", dateTab[2]);
                timeSpan.setAttribute(beginDayTimeSpan);
                dateTab = dateUtil.arrayDate(timeSpanDTO.getEndTimeSpan());
                Attribute endYearTimeSpan = new Attribute("endYear", dateTab[0]);
                timeSpan.setAttribute(endYearTimeSpan);
                Attribute endMonthTimeSpan = new Attribute("endMonth", dateTab[1]);
                timeSpan.setAttribute(endMonthTimeSpan);
                Attribute endDayTimeSpan = new Attribute("endDay", dateTab[2]);
                timeSpan.setAttribute(endDayTimeSpan);
                if (timeSpanDTO.isLocked()) {
                    locked2 = new Attribute("locked", "true");
                    timeSpan.setAttribute(locked2);
                    continue;
                }
                locked2 = new Attribute("locked", "false");
                timeSpan.setAttribute(locked2);
            }
        }
        Element journals = new Element("journals");
        save.addContent((Content)journals);
        List<JournalDTO> listJournalDTO = this.journalServiceImpl.getAllJournal();
        for (JournalDTO journalDTO : listJournalDTO) {
            Element journal = new Element("journal");
            journals.addContent((Content)journal);
            Attribute idJournal = new Attribute("id", journalDTO.getId());
            journal.setAttribute(idJournal);
            Attribute label = new Attribute("label", journalDTO.getLabel());
            journal.setAttribute(label);
            Attribute prefix = new Attribute("prefix", journalDTO.getPrefix());
            journal.setAttribute(prefix);
            Attribute description = new Attribute("description", journalDTO.getDescription());
            journal.setAttribute(description);
        }
        Element accounts = new Element("accounts");
        save.addContent((Content)accounts);
        List<AccountDTO> listAccountDTO = this.accountServiceImpl.getAllAccount();
        this.accountXML(listAccountDTO, accounts);
        Element transactions = new Element("transactions");
        save.addContent((Content)transactions);
        Element entries = new Element("entries");
        save.addContent((Content)entries);
        List<TransactionDTO> listTransactionDTO = this.transactionServiceImpl.getAllTransactionDTO();
        for (TransactionDTO transactionDTO : listTransactionDTO) {
            Element transaction = new Element("transaction");
            transactions.addContent((Content)transaction);
            Attribute idTransaction = new Attribute("id", transactionDTO.getId());
            transaction.setAttribute(idTransaction);
            String[] dateTab = dateUtil.arrayDate(transactionDTO.getEntryDate());
            Attribute entryDateYear = new Attribute("entryDateYear", dateTab[0]);
            transaction.setAttribute(entryDateYear);
            Attribute entryDateMonth = new Attribute("entryDateMonth", dateTab[1]);
            transaction.setAttribute(entryDateMonth);
            Attribute entryDateDay = new Attribute("entryDateDay", dateTab[2]);
            transaction.setAttribute(entryDateDay);
            Attribute voucherRef = new Attribute("voucherRef", transactionDTO.getVoucherRef());
            transaction.setAttribute(voucherRef);
            Attribute description = new Attribute("description", transactionDTO.getDescription());
            transaction.setAttribute(description);
            Attribute IdJournal = new Attribute("idJournal", transactionDTO.getJournalDTO().getId());
            transaction.setAttribute(IdJournal);
            Attribute IdTimeSpan = new Attribute("idTimeSpan", transactionDTO.getTimeSpanDTO().getId());
            transaction.setAttribute(IdTimeSpan);
            List<EntryDTO> listEntryDTO = this.entryServiceImpl.searchEntryDTOWithTransaction(transactionDTO);
            for (EntryDTO entryDTO : listEntryDTO) {
                Attribute debit;
                Element entry = new Element("entry");
                entries.addContent((Content)entry);
                Attribute idEntry = new Attribute("id", entryDTO.getId());
                entry.setAttribute(idEntry);
                Attribute descriptionEntry = new Attribute("description", entryDTO.getDescription());
                entry.setAttribute(descriptionEntry);
                Attribute amount = new Attribute("amount", entryDTO.getAmount());
                entry.setAttribute(amount);
                Attribute lettering = new Attribute("lettering", entryDTO.getLettering());
                entry.setAttribute(lettering);
                Attribute detail = new Attribute("detail", entryDTO.getDetail());
                entry.setAttribute(detail);
                if (entryDTO.isDebit()) {
                    debit = new Attribute("debit", "true");
                    entry.setAttribute(debit);
                } else {
                    debit = new Attribute("debit", "false");
                    entry.setAttribute(debit);
                }
                Attribute idrefTransaction = new Attribute("idTransaction", transactionDTO.getId());
                entry.setAttribute(idrefTransaction);
                Attribute idAccount = new Attribute("idAccount", entryDTO.getAccountDTO().getId());
                entry.setAttribute(idAccount);
            }
        }
        FilesServiceImpl.enregistre(nameFile);
        return "success";
    }

    public void accountXML(List<AccountDTO> listAccountDTO, Element accounts) {
        for (AccountDTO accountDTO : listAccountDTO) {
            Element account = new Element("account");
            accounts.addContent((Content)account);
            Attribute idAccount = new Attribute("id", accountDTO.getId());
            account.setAttribute(idAccount);
            Attribute label = new Attribute("label", accountDTO.getLabel());
            account.setAttribute(label);
            Attribute type = new Attribute("type", accountDTO.getType());
            account.setAttribute(type);
            Attribute accountNumber = new Attribute("accountNumber", accountDTO.getAccountNumber());
            account.setAttribute(accountNumber);
            Attribute masterAccountNumber = new Attribute("masterAccount", accountDTO.getMasterAccount());
            account.setAttribute(masterAccountNumber);
            this.accountXML(accountDTO.getAccountChildDTO(), accounts);
        }
    }

    static void affiche() {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            sortie.output(document, (OutputStream)System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void enregistre(String fichier) {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            sortie.output(document, (OutputStream)new FileOutputStream(fichier));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String importDatas(String file) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Load file XML : ");
        }
        String result = "error";
        boolean existError = false;
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build(file);
        }
        catch (IOException e) {
            log.error((Object)("Erreur lors de la lecture du fichier " + e.getMessage()));
            e.printStackTrace();
        }
        catch (JDOMException e) {
            log.error((Object)("Erreur lors de la construction du fichier JDOM " + e.getMessage()));
            e.printStackTrace();
        }
        try {
            String label;
            Element racine = document.getRootElement();
            XPath requeteXpath = XPath.newInstance((String)"//journal");
            List results = requeteXpath.selectNodes((Object)racine);
            for (Element noeudCourant : results) {
                String description;
                String prefix;
                label = noeudCourant.getAttribute("label").getValue();
                result = this.journalServiceImpl.createJournal(label, prefix = noeudCourant.getAttribute("prefix").getValue(), description = noeudCourant.getAttribute("description").getValue());
                if (!result.equals("error")) continue;
                existError = true;
            }
            requeteXpath = XPath.newInstance((String)"//account");
            results = requeteXpath.selectNodes((Object)racine);
            for (Element noeudCourant : results) {
                String typeAccount;
                String masterAccount;
                label = noeudCourant.getAttribute("label").getValue();
                String accountNumber = noeudCourant.getAttribute("accountNumber").getValue();
                result = this.accountServiceImpl.createAccount(accountNumber, label, masterAccount = noeudCourant.getAttribute("masterAccount").getValue(), typeAccount = noeudCourant.getAttribute("type").getValue());
                if (!result.equals("error")) continue;
                existError = true;
            }
            requeteXpath = XPath.newInstance((String)"//period");
            results = requeteXpath.selectNodes((Object)racine);
            for (Element noeudCourant : results) {
                String idPeriod = noeudCourant.getAttribute("id").getValue();
                int year = Integer.parseInt(noeudCourant.getAttribute("beginYear").getValue());
                int month = Integer.parseInt(noeudCourant.getAttribute("beginMonth").getValue());
                int day = Integer.parseInt(noeudCourant.getAttribute("beginDay").getValue());
                Date beginPeriod = new Date(year - 1900, month, day);
                Date endPeriod = new Date((year = Integer.parseInt(noeudCourant.getAttribute("endYear").getValue())) - 1900, month = Integer.parseInt(noeudCourant.getAttribute("endMonth").getValue()), day = Integer.parseInt(noeudCourant.getAttribute("endDay").getValue()));
                result = this.periodServiceImpl.createPeriod(beginPeriod, endPeriod, false);
                if (result.equals("error")) {
                    existError = true;
                }
                requeteXpath = XPath.newInstance((String)("//transaction[@idTimeSpan=//timespan[@idPeriod='" + idPeriod + "']/@id]"));
                List resultsTransaction = requeteXpath.selectNodes((Object)racine);
                for (Element noeudCourantTrans : resultsTransaction) {
                    String idTransactionXML = noeudCourantTrans.getAttribute("id").getValue();
                    String idJournal = noeudCourantTrans.getAttribute("idJournal").getValue();
                    requeteXpath = XPath.newInstance((String)("//journal[@id='" + idJournal + "']/@label"));
                    String label2 = requeteXpath.valueOf((Object)racine);
                    JournalDTO journalDTO = this.journalServiceImpl.searchJournalDTOWithLabel(label2);
                    String idtimeSpan = noeudCourantTrans.getAttribute("idTimeSpan").getValue();
                    requeteXpath = XPath.newInstance((String)("//timespan[@id='" + idtimeSpan + "']/@beginYear"));
                    year = Integer.parseInt(requeteXpath.valueOf((Object)racine));
                    requeteXpath = XPath.newInstance((String)("//timespan[@id='" + idtimeSpan + "']/@beginMonth"));
                    month = Integer.parseInt(requeteXpath.valueOf((Object)racine));
                    requeteXpath = XPath.newInstance((String)("//timespan[@id='" + idtimeSpan + "']/@beginDay"));
                    day = Integer.parseInt(requeteXpath.valueOf((Object)racine));
                    Date beginTimeSpan = new Date(year - 1900, month, day);
                    TimeSpanDTO timeSpanDTO = this.timeSpanServiceImpl.searchTimeSpanDTOByDate(beginTimeSpan);
                    TransactionDTO transactionDTO = new TransactionDTO();
                    transactionDTO.setJournalDTO(journalDTO);
                    transactionDTO.setTimeSpanDTO(timeSpanDTO);
                    year = Integer.parseInt(noeudCourantTrans.getAttribute("entryDateYear").getValue());
                    month = Integer.parseInt(noeudCourantTrans.getAttribute("entryDateMonth").getValue());
                    day = Integer.parseInt(noeudCourantTrans.getAttribute("entryDateDay").getValue());
                    Date entryDate = new Date(year - 1900, month, day);
                    transactionDTO.setEntryDate(entryDate);
                    String voucherRef = noeudCourantTrans.getAttribute("voucherRef").getValue();
                    transactionDTO.setVoucherRef(voucherRef);
                    String description = noeudCourantTrans.getAttribute("description").getValue();
                    transactionDTO.setDescription(description);
                    String idTransactionCallao = this.transactionServiceImpl.createTransaction(transactionDTO);
                    requeteXpath = XPath.newInstance((String)("//entry[@idTransaction='" + idTransactionXML + "']"));
                    List resultsEntry = requeteXpath.selectNodes((Object)racine);
                    for (Element noeudEntry : resultsEntry) {
                        transactionDTO = this.transactionServiceImpl.searchTransactionDTO(idTransactionCallao);
                        String idAccount = noeudEntry.getAttribute("idAccount").getValue();
                        requeteXpath = XPath.newInstance((String)("//account[@id='" + idAccount + "']/@accountNumber"));
                        String accountNumber = requeteXpath.valueOf((Object)racine);
                        AccountDTO accountDTO = this.accountServiceImpl.searchAccountDTO(accountNumber);
                        EntryDTO entryDTO = new EntryDTO();
                        entryDTO.setAccountDTO(accountDTO);
                        entryDTO.setTransactionDTO(transactionDTO);
                        description = noeudEntry.getAttribute("description").getValue();
                        entryDTO.setDescription(description);
                        String amount = noeudEntry.getAttribute("amount").getValue();
                        entryDTO.setAmount(amount);
                        boolean debit = noeudEntry.getAttribute("debit").getValue().equals("true");
                        entryDTO.setDebit(debit);
                        String lettering = noeudEntry.getAttribute("lettering").getValue();
                        entryDTO.setLettering(lettering);
                        String detail = noeudEntry.getAttribute("detail").getValue();
                        entryDTO.setDetail(detail);
                        result = this.transactionServiceImpl.addEntry(entryDTO);
                        if (!result.equals("error")) continue;
                        existError = true;
                    }
                }
                boolean lock = noeudCourant.getAttribute("locked").getValue().equals("true");
                if (lock) {
                    result = this.periodServiceImpl.blockAllTimeSpanOfPeriod(this.periodServiceImpl.searchPeriodWithDate(beginPeriod));
                    if (result.equals("error")) {
                        existError = true;
                    }
                    result = this.periodServiceImpl.blockPeriod(this.periodServiceImpl.searchPeriodWithDate(beginPeriod));
                    continue;
                }
                requeteXpath = XPath.newInstance((String)("//timespan[@idPeriod = '" + idPeriod + "']"));
                List resultsTimeSpan = requeteXpath.selectNodes((Object)racine);
                for (Element noeudCourantTimeSpan : resultsTimeSpan) {
                    year = Integer.parseInt(noeudCourantTimeSpan.getAttribute("beginYear").getValue());
                    month = Integer.parseInt(noeudCourantTimeSpan.getAttribute("beginMonth").getValue());
                    day = Integer.parseInt(noeudCourantTimeSpan.getAttribute("beginDay").getValue());
                    Date beginTimeSpan = new Date(year - 1900, month, day);
                    lock = noeudCourantTimeSpan.getAttribute("locked").getValue().equals("true");
                    if (lock) {
                        this.timeSpanServiceImpl.blockTimeSpan(this.timeSpanServiceImpl.searchTimeSpanByDate(beginTimeSpan));
                    }
                    if (!result.equals("error")) continue;
                    existError = true;
                }
            }
        }
        catch (JDOMException e) {
            log.error((Object)("Erreur JDOM " + e.getMessage()));
            e.printStackTrace();
        }
        if (!existError) {
            result = "success";
        }
        return result;
    }

    public String[] getMethods() {
        return null;
    }

    public void destroy() {
    }

    public void init(TopiaContext arg0) {
    }
}

