/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.entities.referentiel.Program;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.longline.TripLonglinesUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class TripLonglinesUIHandler
extends ContentListUIHandler<Program, TripLongline> {
    private static final Log log = LogFactory.getLog(TripLonglinesUIHandler.class);

    public TripLonglinesUIHandler(TripLonglinesUI ui) {
        super(ui, DataContextType.Program, DataContextType.TripLongline);
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openProgramId = dataContext.getOpenProgramId();
        if (openProgramId == null) {
            this.addInfoMessage(I18n.n((String)"observe.tripLongline.message.no.active.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Program.class)) {
            this.addInfoMessage(I18n.n((String)"observe.tripLongline.message.active.found", (Object[])new Object[0]));
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.n((String)"observe.tripLongline.message.active.found.for.other.program", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    protected void finalizeOpenUI() {
        String title = this.getDecoratorService().decorate(this.getBean());
        ((ContentUI)this.getUi()).setContentTitle(title);
    }

    @Override
    protected List<TripLongline> getChilds(Program bean) throws DataSourceException {
        DataSource source = this.getDataSource();
        DataService dataService = this.getDataService();
        List list = dataService.getTripLonglineStubByProgram(source, bean.getTopiaId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + list.size() + " trips."));
        }
        return list;
    }
}

