/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.storage.tabs;

import com.google.common.base.Preconditions;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceConfig;
import fr.ird.observe.db.constants.ConnexionStatus;
import fr.ird.observe.db.constants.CreationMode;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.impl.PGDataSourceConfig;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.storage.StorageStep;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUILauncher;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.ui.storage.tabs.BackupUI;
import fr.ird.observe.ui.storage.tabs.ChooseDbModeUI;
import fr.ird.observe.ui.storage.tabs.ConfigDataUI;
import fr.ird.observe.ui.storage.tabs.ConfigReferentielUI;
import fr.ird.observe.ui.storage.tabs.ConfigUI;
import fr.ird.observe.ui.storage.tabs.ConfirmUI;
import fr.ird.observe.ui.storage.tabs.RolesTableModel;
import fr.ird.observe.ui.storage.tabs.RolesUI;
import fr.ird.observe.ui.storage.tabs.SelectDataUI;
import fr.ird.observe.ui.tree.DataSelectionTreeCellRenderer;
import fr.ird.observe.ui.tree.DataSelectionTreeSelectionModel;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.editor.MyDefaultCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class StorageTabUIHandler {
    private static final Log log = LogFactory.getLog(StorageTabUIHandler.class);

    public boolean updateCreationModeLayout(ChooseDbModeUI ui, boolean visible, JRadioButton button) {
        JPanel panel = ui.getUseCreateMode();
        if (visible) {
            for (Component c : panel.getComponents()) {
                if (!button.equals(c)) continue;
                return true;
            }
            panel.add(button);
        } else {
            for (Component c : panel.getComponents()) {
                if (!button.equals(c)) continue;
                panel.remove(c);
                return false;
            }
        }
        return visible;
    }

    public void initUI(final ChooseDbModeUI ui) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                DbMode dbMode = model.getDbMode();
                CreationMode creationMode = model.getCreationMode();
                StringBuilder sb = new StringBuilder();
                StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.selected.dbMode", (Object[])new Object[0]));
                if (dbMode == null) {
                    StorageUIHandler.addTag("pre", sb, I18n.t((String)"observe.storage.no.dbMode", (Object[])new Object[0]));
                } else {
                    StorageUIHandler.addTag("pre", sb, I18n.t((String)dbMode.getDescription(), (Object[])new Object[0]));
                }
                StorageUIHandler.addTag("h3", sb, I18n.t((String)"observe.storage.selectedCreationMode", (Object[])new Object[0]));
                if (DbMode.CREATE_LOCAL == dbMode) {
                    if (creationMode == null) {
                        StorageUIHandler.addTag("pre", sb, I18n.t((String)"observe.storage.no.creationMode", (Object[])new Object[0]));
                    } else {
                        StorageUIHandler.addTag("pre", sb, I18n.t((String)creationMode.getDescription(), (Object[])new Object[0]));
                    }
                } else {
                    StorageUIHandler.addTag("pre", sb, I18n.t((String)"observe.storage.no.creationMode.required", (Object[])new Object[0]));
                }
                String txt = sb.toString();
                ui.getResume().setText(txt);
            }
        };
        StorageUIModel model = ui.getModel();
        model.addPropertyChangeListener("dbMode", listener);
        model.addPropertyChangeListener("creationMode", listener);
        ui.setDescriptionText(I18n.t((String)ui.getStep().getDescription(), (Object[])new Object[0]));
    }

    public void initUI(final ConfigUI ui) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StorageUIModel model = (StorageUIModel)((Object)evt.getSource());
                String propertyName = evt.getPropertyName();
                if ("creationMode".equals(propertyName) || "dbMode".equals(propertyName)) {
                    String id = null;
                    if (model.getDbMode() == DbMode.USE_REMOTE) {
                        id = DbMode.USE_REMOTE.name();
                    } else if (model.getCreationMode() != null) {
                        id = model.getCreationMode().name();
                    }
                    if (id != null) {
                        StorageTabUIHandler.this.refreshConfig(ui, id);
                    }
                }
            }
        };
        ui.getModel().addPropertyChangeListener(listener);
    }

    public void initUI(final ConfigReferentielUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n.t((String)ui.getStep().getDescription(), (Object[])new Object[0]));
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propertyName = evt.getPropertyName();
                    if ("referentielImportMode".equals(propertyName)) {
                        CreationMode id = (CreationMode)evt.getNewValue();
                        StorageTabUIHandler.this.refreshConfig(ui, id.name());
                    }
                }
            };
            ui.getModel().addPropertyChangeListener(listener);
            ui.getModel().setReferentielImportMode(CreationMode.IMPORT_EXTERNAL_DUMP);
        }
    }

    public void initUI(final ConfigDataUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n.t((String)ui.getStep().getDescription(), (Object[])new Object[0]));
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CreationMode id;
                    String propertyName = evt.getPropertyName();
                    if ("dataImportMode".equals(propertyName) && (id = (CreationMode)evt.getNewValue()) != null) {
                        StorageTabUIHandler.this.refreshConfig(ui, id.name());
                    }
                }
            };
            ui.getModel().addPropertyChangeListener(listener);
            ui.getModel().setDataImportMode(CreationMode.EMPTY);
        }
    }

    public void initUI(final RolesUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n.t((String)ui.getStep().getDescription(), (Object[])new Object[0]));
        }
        ui.getSecurityModel().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Security model changed [" + evt.getPropertyName() + "] <" + evt.getOldValue() + " : " + evt.getNewValue() + ">"));
                }
                ui.getModel().validate();
            }
        });
        JTable table = ui.getRoles();
        table.setRowHeight(24);
        UIHelper.fixTableColumnWidth((JTable)table, (int)1, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)2, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)3, (int)100);
        UIHelper.fixTableColumnWidth((JTable)table, (int)4, (int)100);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{RolesTableModel.COLUMN_NAMES[0], RolesTableModel.COLUMN_NAME_TIPS[0], RolesTableModel.COLUMN_NAMES[1], RolesTableModel.COLUMN_NAME_TIPS[1], RolesTableModel.COLUMN_NAMES[2], RolesTableModel.COLUMN_NAME_TIPS[2], RolesTableModel.COLUMN_NAMES[3], RolesTableModel.COLUMN_NAME_TIPS[3], RolesTableModel.COLUMN_NAMES[4], RolesTableModel.COLUMN_NAME_TIPS[4]});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)50, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer(renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer(renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer(renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)4, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer(renderer));
        UIHelper.setTableColumnEditor((JTable)table, (int)1, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor());
        UIHelper.setTableColumnEditor((JTable)table, (int)2, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor());
        UIHelper.setTableColumnEditor((JTable)table, (int)3, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor());
        UIHelper.setTableColumnEditor((JTable)table, (int)4, (TableCellEditor)MyDefaultCellEditor.newBooleanEditor());
    }

    public void initUI(SelectDataUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n.t((String)ui.getStep().getDescription(), (Object[])new Object[0]));
        }
        DataSelectionTreeCellRenderer.initUI(ui.getSelectedTreePane(), ui.getSelectTree());
    }

    public void initUI(BackupUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n.t((String)ui.getStep().getDescription(), (Object[])new Object[0]));
        }
    }

    public void initUI(ConfirmUI ui) {
        if (ui.getStep() != null) {
            ui.setDescriptionText(I18n.t((String)ui.getStep().getDescription(), (Object[])new Object[0]));
        }
    }

    public void chooseBackupFile(BackupUI ui) {
        File f = UIHelper.chooseDirectory(ui, I18n.t((String)"observe.title.choose.db.dump.directory", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.db.dump.directory", (Object[])new Object[0]), new File(ui.getDirectoryText().getText()));
        this.changeDirectory(ui, f);
    }

    public void changeDirectory(BackupUI ui, File f) {
        ui.getModel().setBackupFile(new File(f, ui.getFilenameText().getText()));
    }

    public void changeFilename(BackupUI ui, String filename) {
        ui.getModel().setBackupFile(new File(ui.getDirectoryText().getText(), filename));
    }

    public void refreshConfig(ConfigUI ui, String configId) {
        JComponent c = (JComponent)ui.getObjectById(configId);
        if (c != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)configId);
            }
            ui.configLayout.show(ui.configContent, configId);
            String text = (String)c.getClientProperty("description");
            ui.setDescriptionText(I18n.t((String)text, (Object[])new Object[0]));
            if (c.equals(ui.IMPORT_REMOTE_STORAGE)) {
                ui.IMPORT_REMOTE_STORAGE_content.add((Component)ui.remoteConfig, "Center");
            } else if (c.equals(ui.USE_REMOTE)) {
                ui.USE_REMOTE_content.add((Component)ui.remoteConfig, "Center");
            }
        }
    }

    public void refreshConfig(ConfigReferentielUI ui, String configId) {
        JComponent c = (JComponent)ui.getObjectById(configId);
        if (c != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)configId);
            }
            ui.configLayout.show(ui.configContent, configId);
        }
    }

    public void refreshConfig(ConfigDataUI ui, String configId) {
        JComponent c = (JComponent)ui.getObjectById(configId);
        if (c != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)configId);
            }
            ui.configLayout.show(ui.configContent, configId);
        }
    }

    public Icon updateConnexionStatutIcon(ConfigUI ui, ConnexionStatus status) {
        Icon icon = (Icon)ui.getConnexionStatus().getClientProperty(status.name().toLowerCase() + "Icon");
        return icon;
    }

    public Color updateConnexionStatutColor(ConfigUI ui, ConnexionStatus status) {
        Color color = (Color)ui.getConnexionStatus().getClientProperty(status.name().toLowerCase() + "Color");
        return color;
    }

    public String updateConnexionStatutText(ConfigUI ui, ConnexionStatus status) {
        String text = status.getDescription();
        switch (status) {
            case UNTESTED: {
                text = I18n.t((String)text, (Object[])new Object[0]);
                break;
            }
            case SUCCESS: {
                text = I18n.t((String)text, (Object[])new Object[]{ui.model.getPgConfig().toString()});
                break;
            }
            case FAILED: {
                if (ui.model.getPgConfig().getConnexionError() != null) {
                    text = I18n.t((String)text, (Object[])new Object[]{ui.model.getPgConfig().getConnexionError().getMessage()});
                    break;
                }
                Preconditions.checkState((!ui.model.isPgConfigVersionMatch() ? 1 : 0) != 0);
                String error = I18n.t((String)"observe.storage.error.dbVersionMismatch", (Object[])new Object[]{ui.model.getPgConfig().getVersion(), ui.model.getDbVersion()});
                text = I18n.t((String)text, (Object[])new Object[]{error});
            }
        }
        return text;
    }

    public void chooseDumpFile(ConfigUI ui) {
        File f = UIHelper.chooseFile(ui, I18n.t((String)"observe.title.choose.db.dump", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.db.dump", (Object[])new Object[0]), ui.getModel().getDumpFile(), "^.+\\.sql\\.gz$", I18n.t((String)"observe.action.choose.db.dump.description", (Object[])new Object[0]));
        ui.getModel().setDumpFile(f);
    }

    public void chooseDumpFile(ConfigReferentielUI ui) {
        File f = UIHelper.chooseFile(ui, I18n.t((String)"observe.title.choose.db.dump", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.db.dump", (Object[])new Object[0]), ui.getModel().getDumpFile(), "^.+\\.sql\\.gz$", I18n.t((String)"observe.action.choose.db.dump.description", (Object[])new Object[0]));
        ui.getCentralSourceModel().setDumpFile(f);
        ui.getModel().validate();
    }

    public void chooseDumpFile(ConfigDataUI ui) {
        File f = UIHelper.chooseFile(ui, I18n.t((String)"observe.title.choose.db.dump", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.db.dump", (Object[])new Object[0]), ui.getModel().getDumpFile(), "^.+\\.sql\\.gz$", I18n.t((String)"observe.action.choose.db.dump.description", (Object[])new Object[0]));
        ui.getCentralSourceModel().setDumpFile(f);
        ui.getModel().validate();
    }

    public void initTree(SelectDataUI ui, DataSource source) {
        StorageUIModel model = ui.getModel();
        if (model.isUseSelectData()) {
            DataSelectionModel dataModel = model.getSelectDataModel();
            ObserveTreeHelper helper = new ObserveTreeHelper();
            JTree tree = ui.selectTree;
            helper.setUI(tree, false, null);
            tree.setModel(helper.createModel((JAXXContext)ui, dataModel, source));
            DataSelectionTreeSelectionModel selectionModel = ui.getSelectionModel();
            selectionModel.initUI(tree);
            selectionModel.setDataModel(dataModel);
        }
    }

    protected String updateInternalDumpModeLabel(ChooseDbModeUI ui, boolean dumpExist) {
        File f = ui.getContextValue(ObserveConfig.class).getInitialDbDump();
        String text = f.exists() ? I18n.t((String)"observe.storage.internalDump.last.modified", (Object[])new Object[]{new Date(f.lastModified())}) : I18n.t((String)"observe.storage.internalDump.not.exist", (Object[])new Object[0]);
        return I18n.t((String)CreationMode.IMPORT_INTERNAL_DUMP.getLabel(), (Object[])new Object[0]) + text;
    }

    protected String updateCanMigrateLabel(ChooseDbModeUI ui, boolean canMigrate) {
        String text = I18n.t((String)"observe.storage.action.canMigrate", (Object[])new Object[]{ui.getModel().getDbVersion()});
        return text;
    }

    public void obtainRemoteConnexion(ConfigReferentielUI ui) {
        StorageUIModel sourceModel = ui.getCentralSourceModel();
        StorageUILauncher.obtainRemoteConnexion(ui.getDelegateContext(), ui.getParentContainer(Window.class), sourceModel);
        PGDataSourceConfig config = sourceModel.toPostgresStorageConfig("Import r\u00e9f\u00e9rentiel");
        ui.getModel().getPgConfig().setImportConfig((DataSourceConfig)config);
        sourceModel.validate(StorageStep.CONFIG);
        ui.getModel().validate();
    }

    public void obtainRemoteConnexion(ConfigDataUI ui) {
        StorageUIModel sourceModel = ui.getCentralSourceModel();
        StorageUILauncher.obtainRemoteConnexion(ui.getDelegateContext(), ui.getParentContainer(Window.class), sourceModel);
        sourceModel.validate(StorageStep.CONFIG);
        ui.getModel().validate();
    }

    public String updateStorageLabel(StorageUIModel service, boolean serviceValid, JLabel label) {
        String text = serviceValid ? service.getLabel() : I18n.t((String)((String)label.getClientProperty("no")), (Object[])new Object[0]);
        return text;
    }

    protected String updateDataSourcePolicy(StorageUIModel sourceModel, boolean valid) {
        if (!valid) {
            return I18n.t((String)"observe.common.storage.not.valid", (Object[])new Object[0]);
        }
        Object config = sourceModel.getDbMode() == DbMode.USE_REMOTE ? sourceModel.getPgConfig() : sourceModel.getH2Config();
        return config.getPolicyLabel();
    }
}

