/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.tree;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.OpenableEntity;
import fr.ird.observe.ui.tree.ObserveDataProvider;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.loadors.AbstractNodeChildLoador;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.swing.nav.NavBridge;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class EntityNodeSupport<E extends TopiaEntity>
extends ObserveNode {
    private static final Log log = LogFactory.getLog(EntityNodeSupport.class);
    private static final long serialVersionUID = 1L;
    protected transient E entity;
    protected transient DataService dataService;
    private boolean reloadEntity;

    protected abstract E getEntity(DataService var1, DataSource var2) throws DataSourceException;

    protected EntityNodeSupport(Class<E> internalClass, E entity) {
        this(internalClass, entity, null);
    }

    protected EntityNodeSupport(Class<E> type, E entity, AbstractNodeChildLoador<?> childLoador) {
        this(type, entity, null, childLoador);
    }

    protected EntityNodeSupport(Class<E> type, E entity, String context, AbstractNodeChildLoador<?> childLoador) {
        super(type, entity.getTopiaId(), context, childLoador, false);
        this.setEntity(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateNode(NavBridge<DefaultTreeModel, ObserveNode> bridge, NavDataProvider provider, boolean populateChilds) {
        try {
            super.populateNode(bridge, provider, populateChilds);
        }
        finally {
            this.reloadEntity = false;
        }
        if (provider != null && this.id != null) {
            if (this.entity == null) {
                this.loadEntity((ObserveDataProvider)provider);
            }
            if (OpenableEntity.class.isAssignableFrom(this.entity.getClass())) {
                this.open = ((OpenableEntity)this.entity).isOpen();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Set open: " + this.open + " for entity: " + this.id));
                }
            }
        }
    }

    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty && this.reloadEntity) {
            this.entity = null;
        }
    }

    public E getEntity() {
        return this.entity;
    }

    public void setEntity(E entity) {
        this.entity = entity;
    }

    protected void loadEntity(ObserveDataProvider oProvider) {
        if (oProvider.getSelectionModel() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("try to get entity from selectionModel " + this.internalClass + " : " + this.id));
            }
            this.entity = oProvider.getSelectionModel().getEntityCache(this.id);
        }
        if (this.entity == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("will load entity " + this.internalClass.getSimpleName() + " : " + this.id));
            }
            try {
                this.entity = this.getEntity(this.getDataService(), oProvider.getDataSource());
            }
            catch (DataSourceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private DataService getDataService() {
        if (this.dataService == null) {
            this.dataService = ObserveContext.get().getDataService();
        }
        return this.dataService;
    }

    public void setReloadEntity(boolean reloadEntity) {
        this.reloadEntity = reloadEntity;
    }
}

