/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.entities.longline.Basket;
import fr.ird.observe.entities.longline.BasketImpl;
import fr.ird.observe.entities.longline.SectionTemplate;
import fr.ird.observe.ui.content.impl.longline.LonglineCompositionTableModelSupport;
import fr.ird.observe.ui.content.impl.longline.LonglineDetailCompositionUIModel;

public class BasketsTableModel
extends LonglineCompositionTableModelSupport<Basket> {
    private static final long serialVersionUID = 1L;

    public BasketsTableModel(LonglineDetailCompositionUIModel model) {
        super(model);
    }

    @Override
    protected Basket createNewRow() {
        return new BasketImpl();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean result;
        switch (columnIndex) {
            case 0: {
                result = false;
                break;
            }
            case 1: {
                result = !this.isGenerateHaulingIds();
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 3: {
                result = true;
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Number result;
        Basket row = (Basket)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = row.getSettingIdentifier();
                break;
            }
            case 1: {
                result = row.getHaulingIdentifier();
                break;
            }
            case 2: {
                result = row.getFloatline1Length();
                break;
            }
            case 3: {
                result = row.getFloatline2Length();
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Basket row = (Basket)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                row.setSettingIdentifier((Integer)aValue);
                break;
            }
            case 1: {
                row.setHaulingIdentifier((Integer)aValue);
                break;
            }
            case 2: {
                row.setFloatline1Length((Float)aValue);
                break;
            }
            case 3: {
                row.setFloatline2Length((Float)aValue);
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        this.setModified(true);
    }

    public void applySectionTemplate(SectionTemplate newTemplate) {
        newTemplate.applyToBaskets(this.data);
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
        this.setModified(true);
    }
}

