/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.referentiel.FpaZone;
import fr.ird.observe.entities.referentiel.seine.VesselActivitySeine;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.TripSeine;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.seine.ActivitySeineUI;
import fr.ird.observe.ui.content.open.impl.seine.ActivitySeineUIModel;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.DateUtil;
import org.nuiton.validator.NuitonValidatorScope;

public class ActivitySeineUIHandler
extends ContentOpenableUIHandler<ActivitySeine> {
    private static Log log = LogFactory.getLog(ActivitySeineUIHandler.class);
    protected final TableModelListener computeTabValidStateListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            SwingValidatorMessageTableModel source = (SwingValidatorMessageTableModel)e.getSource();
            ActivitySeineUIHandler.this.computeTabValidState(source);
        }
    };

    public ActivitySeineUIHandler(ActivitySeineUI ui) {
        super(ui, DataContextType.Route, DataContextType.ActivitySeine, I18n.n((String)"observe.activitySeine.message.not.open", (Object[])new Object[0]));
    }

    @Override
    public ActivitySeineUI getUi() {
        return (ActivitySeineUI)super.getUi();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String activityId = this.getSelectedId();
        if (activityId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(ActivitySeine.class)) {
            return ContentMode.UPDATE;
        }
        ActivitySeineUI ui = this.getUi();
        if (!dataContext.isSelectedOpen(Route.class)) {
            ActivitySeineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Route.class), I18n.t((String)"observe.route.message.not.open", (Object[])new Object[0]));
        } else if (!dataContext.isSelectedOpen(TripSeine.class)) {
            ActivitySeineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(TripSeine.class), I18n.t((String)"observe.tripSeine.message.not.open", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)this.getModel()).isHistoricalData()) {
                this.addInfoMessage(I18n.t((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        } else {
            this.addInfoMessage(I18n.t((String)this.closeMessage, (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
        this.getUi().getErrorTableModel().addTableModelListener(this.computeTabValidStateListener);
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        this.resetQuadrant(this.getUi().getCoordinatesEditor());
        String routeId = this.getSelectedParentId();
        String activityId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "routeId    = " + routeId));
            log.info((Object)(this.prefix + "activityId = " + activityId));
        }
        ContentMode mode = this.computeContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "content mode " + (Object)((Object)mode)));
        }
        ActivitySeine bean = (ActivitySeine)this.getBean();
        DataService dataService = this.getDataService();
        boolean create = activityId == null;
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (create) {
            dataService.preCreate(source, routeId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, activityId, this.getLoadExecutor());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.prefix + "long  - lat  = " + bean.getLongitude() + " - " + bean.getLatitude()));
        }
        SwingValidatorMessageTableModel errorTableModel = this.getUi().getErrorTableModel();
        this.computeTabValidState(errorTableModel);
        this.finalizeOpenUI(mode, create);
        this.getUi().getCoordinatesEditor().setLatitudeAndLongitude(bean.getLatitude(), bean.getLongitude());
        if (create) {
            Integer quadrant = bean.getQuadrant();
            this.getUi().getCoordinatesEditor().setQuadrant(null);
            this.getUi().getCoordinatesEditor().setQuadrant(quadrant);
        }
        this.getModel().setModified(create);
    }

    @Override
    protected ActivitySeine onPreCreate(TopiaContext tx, Object parent, ActivitySeine bean) throws TopiaException {
        Date time;
        Route parentBean = (Route)parent;
        bean.setOpen(true);
        bean.setLatitude(null);
        bean.setLongitude(null);
        FpaZone currentFpaZone = null;
        ActivitySeine lastActivitySeine = parentBean.getLastActivity();
        if (lastActivitySeine == null) {
            time = new Date();
        } else {
            lastActivitySeine.initCoordinates();
            Integer quadrant = lastActivitySeine.getQuadrant();
            if (quadrant != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use quadrant of previous activity [" + quadrant + "]"));
                }
                bean.setQuadrant(quadrant);
            }
            time = lastActivitySeine.getTime();
            currentFpaZone = lastActivitySeine.getNextFpaZone();
            if (currentFpaZone == null) {
                currentFpaZone = lastActivitySeine.getCurrentFpaZone();
            }
        }
        bean.setTime(DateUtil.getTime((Date)time, (boolean)false, (boolean)false));
        bean.setCurrentFpaZone(currentFpaZone);
        if (log.isDebugEnabled()) {
            log.debug((Object)("has pre-created :  " + bean));
        }
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        ActivitySeineUI ui = this.getUi();
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        ui.getValidator().setContext(contextName);
        if (create) {
            ActivitySeineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(ActivitySeine.class), I18n.t((String)"observe.activitySeine.message.creating", (Object[])new Object[0]));
        } else {
            ActivitySeineUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(ActivitySeine.class), I18n.t((String)"observe.activitySeine.message.updating", (Object[])new Object[0]));
        }
        super.startEditUI("time.time", "vesselSpeed.model", "seaSurfaceTemperature.model", "comment2.text", "vesselActivitySeine.selectedItem", "previousFpaZone.selectedItem", "currentFpaZone.selectedItem", "nextFpaZone.selectedItem", "surroundingActivity.selectedItem", "close.enabled", "addSet.enabled", "closeAndCreate.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(ActivitySeine bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<ActivitySeine> binder) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("           long  - lat = " + bean.getLongitude() + " - " + bean.getLatitude()));
        }
        boolean create = bean.getTopiaId() == null;
        String routeId = this.getSelectedParentId();
        bean.setOpen(true);
        if (create) {
            bean = (ActivitySeine)dataService.create(dataSource, routeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, routeId, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected ActivitySeine onCreate(TopiaContext tx, Object parent, ActivitySeine editBean) throws TopiaException {
        Route parentBean = (Route)parent;
        ActivitySeine beanToSave = (ActivitySeine)ObserveDAOHelper.getActivitySeineDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addActivitySeine(beanToSave);
        return beanToSave;
    }

    @Override
    protected ActivitySeine onUpdate(TopiaContext tx, Object parentBean, ActivitySeine beanToSave) throws TopiaException {
        ActivitySeine editBean = (ActivitySeine)this.getBean();
        Route route = (Route)parentBean;
        Date d = DateUtil.getDateAndTime((Date)route.getDate(), (Date)editBean.getTime(), (boolean)false, (boolean)false);
        editBean.setTime(d);
        if (log.isInfoEnabled()) {
            log.info((Object)("Final time to use : " + d));
        }
        this.getLoadBinder().copyExcluding((Object)editBean, (Object)beanToSave, new String[]{"floatingObject", "observedSystem"});
        if (log.isInfoEnabled()) {
            log.info((Object)("Is activity open ? : " + beanToSave.isOpen()));
        }
        return beanToSave;
    }

    @Override
    protected boolean doDelete(ActivitySeine bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, ActivitySeine> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Will delete Activity " + bean.getTopiaId()));
        }
        String routeId = this.getSelectedParentId();
        dataService.delete(dataSource, routeId, (TopiaEntity)bean, deletor);
        if (log.isInfoEnabled()) {
            log.info((Object)("Delete done for Activity " + bean.getTopiaId()));
        }
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, ActivitySeine beanToDelete) {
        Route parentBean = (Route)parent;
        parentBean.removeActivitySeine(beanToDelete);
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        boolean canReopen = !create && dataContext.isSelectedOpen(Route.class) && !dataContext.isOpenActivity();
        return canReopen;
    }

    public String getActivity6Label() {
        try {
            List activitys = this.getDataService().getList(this.getDataSource(), VesselActivitySeine.class);
            for (VesselActivitySeine a : activitys) {
                if (!"6".equals(a.getCode())) continue;
                String label = this.getDecoratorService().decorate((Object)a);
                return label;
            }
        }
        catch (DataSourceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        throw new IllegalStateException(I18n.t((String)"observe.error.no.activity.6", (Object[])new Object[0]));
    }

    protected void computeTabValidState(SwingValidatorMessageTableModel errorTableModel) {
        HashSet<String> errorProperties = new HashSet<String>();
        int rowCount = errorTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            SwingValidatorMessage row = errorTableModel.getRow(i);
            if (!NuitonValidatorScope.ERROR.equals((Object)row.getScope())) continue;
            errorProperties.add(row.getField());
        }
        boolean generalTabValid = !errorProperties.removeAll(ActivitySeineUIModel.GENERAL_TAB_PROPERTIES);
        boolean measurementsTabValid = !errorProperties.removeAll(ActivitySeineUIModel.MEASUREMENTS_TAB_PROPERTIES);
        ActivitySeineUIModel model = (ActivitySeineUIModel)this.getModel();
        model.setGeneralTabValid(generalTabValid);
        model.setMeasurementsTabValid(measurementsTabValid);
    }
}

