/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.Species2;
import fr.ird.observe.entities.referentiel.seine.SpeciesStatus;
import fr.ird.observe.entities.seine.FloatingObject;
import fr.ird.observe.entities.seine.ObjectObservedSpecies;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.seine.ObjectObservedSpeciesUI;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ObjectObservedSpeciesUIHandler
extends ContentTableUIHandler<FloatingObject, ObjectObservedSpecies> {
    private static Log log = LogFactory.getLog(ObjectObservedSpeciesUIHandler.class);

    public ObjectObservedSpeciesUIHandler(ObjectObservedSpeciesUI ui) {
        super(ui, DataContextType.SetSeine);
    }

    @Override
    public ObjectObservedSpeciesUI getUi() {
        return (ObjectObservedSpeciesUI)super.getUi();
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedFloatingObjectId();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, ObjectObservedSpecies bean, boolean create) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Row has changed to " + editingRow));
        }
        if (this.getTableModel().isEditable()) {
            this.getUi().getSpecies().requestFocus();
        }
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.objectObservedSpecies.table.speciesFaune", (Object[])new Object[0]), I18n.n((String)"observe.objectObservedSpecies.table.speciesFaune.tip", (Object[])new Object[0]), I18n.n((String)"observe.objectObservedSpecies.table.speciesStatus", (Object[])new Object[0]), I18n.n((String)"observe.objectObservedSpecies.table.speciesStatus.tip", (Object[])new Object[0]), I18n.n((String)"observe.objectObservedSpecies.table.count", (Object[])new Object[0]), I18n.n((String)"observe.objectObservedSpecies.table.count.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SpeciesStatus.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    public void initUI() throws Exception {
        ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
        String speciesListId = config.getSpeciesListSeineObjectObservedSpecies();
        Set speciesIds = this.getDataService().getSpeciesListSpeciesIds(this.getDataSource(), speciesListId);
        this.getUi().getSpecies().putClientProperty((Object)"listPredicate", (Object)Species2.newSpeciesByIdPredicate((Set)speciesIds));
        super.initUI();
    }
}

