/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.constants.seine.SchoolType;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.seine.ActivitySeineObservedSystemUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class ActivitySeineObservedSystemUIHandler
extends ContentUIHandler<ActivitySeine> {
    private static Log log = LogFactory.getLog(ActivitySeineObservedSystemUIHandler.class);

    public ActivitySeineObservedSystemUIHandler(ActivitySeineObservedSystemUI ui) {
        super(ui, DataContextType.ActivitySeine, null);
    }

    public ActivitySeineObservedSystemUI getUi() {
        return (ActivitySeineObservedSystemUI)super.getUi();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(ActivitySeine.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.t((String)"observe.message.activity.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activityId = this.getSelectedParentId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
        }
        ContentMode mode = this.computeContentMode();
        this.getDataService().loadEditEntity(this.getDataSource(), activityId, this.getLoadExecutor());
        this.getModel().setMode(mode);
        if (mode == ContentMode.UPDATE) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        this.addInfoMessage(I18n.t((String)"observe.message.updating.activity", (Object[])new Object[0]));
        super.startEditUI(binding);
    }

    @Override
    protected boolean doSave(ActivitySeine bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<ActivitySeine> binder) throws Exception {
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected ActivitySeine onUpdate(TopiaContext tx, Object parentBean, ActivitySeine beanToSave) throws TopiaException {
        ActivitySeine bean = (ActivitySeine)this.getBean();
        boolean needUpdateSet = false;
        SchoolType newTypeBanc = bean.getSchoolType();
        SetSeine set = bean.getSetSeine();
        if (set != null) {
            SchoolType oldTypeBanc = set.getSchoolType();
            needUpdateSet = oldTypeBanc == null || newTypeBanc != oldTypeBanc;
        }
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"setSeine"});
        if (needUpdateSet) {
            beanToSave.getSetSeine().setSchoolType(newTypeBanc);
        }
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
    }
}

