/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.seine;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.constants.seine.SchoolType;
import fr.ird.observe.entities.referentiel.seine.ObservedSystem;
import fr.ird.observe.entities.seine.ActivitySeine;
import fr.ird.observe.entities.seine.SetSeine;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.seine.ActivitySeineObservedSystemUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public class ActivitySeineObservedSystemUIHandler
extends ContentUIHandler<ActivitySeine> {
    private static Log log = LogFactory.getLog(ActivitySeineObservedSystemUIHandler.class);

    public ActivitySeineObservedSystemUIHandler(ActivitySeineObservedSystemUI ui) {
        super(ui, DataContextType.ActivitySeine, null);
    }

    public ActivitySeineObservedSystemUI getUi() {
        return (ActivitySeineObservedSystemUI)super.getUi();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(ActivitySeine.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.t((String)"observe.message.activity.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activityId = this.getSelectedParentId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
        }
        ContentMode mode = this.computeContentMode();
        this.getDataService().loadEditEntity(this.getDataSource(), activityId, this.getLoadExecutor());
        this.getModel().setMode(mode);
        if (mode == ContentMode.UPDATE) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        this.addInfoMessage(I18n.t((String)"observe.message.updating.activity", (Object[])new Object[0]));
        super.startEditUI(binding);
    }

    @Override
    protected boolean doSave(ActivitySeine bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<ActivitySeine> binder) throws Exception {
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected ActivitySeine onUpdate(TopiaContext tx, Object parentBean, ActivitySeine beanToSave) throws TopiaException {
        ActivitySeine bean = (ActivitySeine)this.getBean();
        boolean needUpdateSet = false;
        SchoolType newTypeBanc = bean.getSchoolType();
        SetSeine set = bean.getSetSeine();
        if (set != null) {
            SchoolType oldTypeBanc = set.getSchoolType();
            needUpdateSet = oldTypeBanc == null || newTypeBanc != oldTypeBanc;
        }
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"setSeine"});
        if (needUpdateSet) {
            beanToSave.getSetSeine().setSchoolType(newTypeBanc);
        }
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectObservedSystem(ActivitySeine bean, Object[] selected) {
        boolean update;
        if (!this.getModel().isEditing()) {
            return;
        }
        boolean bl = update = selected.length != bean.sizeObservedSystem();
        if (!update && selected.length > 0) {
            List list = bean.getObservedSystem();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = this.getUi().getObservedSystem().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                ArrayList<ObservedSystem> newList = new ArrayList<ObservedSystem>(selected.length);
                for (Object o : selected) {
                    newList.add((ObservedSystem)o);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update objectOperations " + newList.size()));
                }
                bean.setObservedSystem(newList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    protected int[] updateIndices(List<ObservedSystem> list) {
        int i;
        if (log.isInfoEnabled()) {
            log.info((Object)(list == null ? 0 : list.size()));
        }
        List ids = list == null ? Collections.emptyList() : TopiaEntityHelper.getTopiaIdList(list);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (list != null && !list.isEmpty()) {
            ListModel model = this.getUi().getObservedSystem().getModel();
            int max = model.getSize();
            for (i = 0; i < max; ++i) {
                ObservedSystem s = (ObservedSystem)model.getElementAt(i);
                if (!ids.contains(s.getTopiaId())) continue;
                indices.add(i);
            }
        }
        int[] result = new int[indices.size()];
        i = 0;
        for (Integer indice : indices) {
            result[i++] = indice;
        }
        indices.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected indices : " + Arrays.toString(result)));
        }
        return result;
    }
}

