/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.open.impl.seine;

import fr.ird.observe.BinderService;
import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.db.util.TopiaExecutor2;
import fr.ird.observe.entities.referentiel.seine.VesselActivity;
import fr.ird.observe.entities.seine.Activity;
import fr.ird.observe.entities.seine.Route;
import fr.ird.observe.entities.seine.Trip;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIModel;
import fr.ird.observe.ui.content.open.ContentOpenableUIHandler;
import fr.ird.observe.ui.content.open.ContentOpenableUIModel;
import fr.ird.observe.ui.content.open.impl.seine.ActivityUI;
import java.util.Date;
import java.util.List;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;
import org.nuiton.validator.NuitonValidatorScope;

public class ActivityUIHandler
extends ContentOpenableUIHandler<Activity> {
    private static Log log = LogFactory.getLog(ActivityUIHandler.class);

    public ActivityUIHandler(ActivityUI ui) {
        super(ui, DataContextType.Route, DataContextType.Activity, I18n.n((String)"observe.message.activity.not.open", (Object[])new Object[0]));
    }

    @Override
    public ActivityUI getUi() {
        return (ActivityUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Activity> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Activity.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Activity.class, new String[]{"quadrant", "latitude", "longitude", "time", "seaSurfaceTemperature", "reasonForNoFishing", "comment", "vesselSpeed", "observedSystem", "observedSystemDistance", "vesselActivity", "surroundingActivity", "wind", "detectionMode", "set", "floatingObject", "open", "currentFpaZone", "previousFpaZone", "nextFpaZone", "latitudeAsDegre", "latitudeAsMinute", "latitudeAsSeconde", "longitudeAsDegre", "longitudeAsMinute", "longitudeAsSeconde", "useSexagecimalFormat"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"observedSystem"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"floatingObject"});
            r = binderService.registerTopiaBinder(Activity.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String activityId = this.getSelectedId();
        if (activityId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Activity.class)) {
            return ContentMode.UPDATE;
        }
        ActivityUI ui = this.getUi();
        if (!dataContext.isSelectedOpen(Route.class)) {
            ActivityUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Route.class), I18n.t((String)"observe.message.route.not.open", (Object[])new Object[0]));
        } else if (!dataContext.isSelectedOpen(Trip.class)) {
            ActivityUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Trip.class), I18n.t((String)"observe.message.maree.not.open", (Object[])new Object[0]));
            if (((ContentOpenableUIModel)this.getModel()).isHistoricalData()) {
                this.addInfoMessage(I18n.t((String)"observe.message.historical.data", (Object[])new Object[0]));
            }
        } else {
            this.addInfoMessage(I18n.t((String)this.closeMessage, (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String routeId = this.getSelectedParentId();
        String activityId = this.getSelectedId();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "routeId    = " + routeId));
            log.info((Object)(this.prefix + "activityId = " + activityId));
        }
        ContentMode mode = this.computeContentMode();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.prefix + "content mode " + (Object)((Object)mode)));
        }
        Activity bean = (Activity)this.getBean();
        bean.setUseSexagecimalFormat(false);
        DataService dataService = this.getDataService();
        boolean create = activityId == null;
        TopiaEntityBinder binder = this.getLoadBinder();
        DataSource source = this.getDataSource();
        if (create) {
            dataService.preCreate(source, routeId, (TopiaEntity)bean, binder, this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(source, activityId, this.getLoadExecutor());
            bean.initCoordonnees();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("           long  - lat  = " + bean.getLongitude() + " - " + bean.getLatitude()));
            log.debug((Object)("quadrant - along - alat = " + bean.getQuadrant() + " - " + bean.getAbsoluteLongitude() + " - " + bean.getAbsoluteLatitude()));
        }
        this.finalizeOpenUI(mode, create);
        bean.setUseSexagecimalFormat(true);
        this.getModel().setModified(create);
    }

    @Override
    protected Activity onPreCreate(TopiaContext tx, Object parent, Activity bean) throws TopiaException {
        Date time;
        Route parentBean = (Route)parent;
        bean.setOpen(true);
        Activity lastActivity = parentBean.getLastActivity();
        if (lastActivity == null) {
            time = new Date();
        } else {
            lastActivity.initCoordonnees();
            Integer quadrant = lastActivity.getQuadrant();
            if (quadrant != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use quadrant of previous activity [" + quadrant + "]"));
                }
                bean.setQuadrant(quadrant);
            }
            time = lastActivity.getTime();
        }
        bean.setTime(DBHelper.getTime((Date)time));
        if (log.isDebugEnabled()) {
            log.debug((Object)("has pre-created :  " + bean));
        }
        return bean;
    }

    @Override
    public void startEditUI(String ... binding) {
        ActivityUI ui = this.getUi();
        ui.getQuadrantBG().clearSelection();
        ContentUIModel model = this.getModel();
        boolean create = model.getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(model.getMode());
        ui.getValidator().setContext(contextName);
        if (create) {
            ActivityUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Activity.class), I18n.t((String)"observe.message.creating.activity", (Object[])new Object[0]));
        } else {
            ActivityUIHandler.addMessage(ui, NuitonValidatorScope.INFO, this.getEntityLabel(Activity.class), I18n.t((String)"observe.message.updating.activity", (Object[])new Object[0]));
        }
        super.startEditUI("time.date", "longitudeDecimal.model", "longitudeAsDegre.model", "longitudeAsMinute.model", "latitudeDecimal.model", "latitudeAsMinute.model", "latitudeAsDegre.model", "quadrant1.selected", "quadrant2.selected", "quadrant3.selected", "quadrant4.selected", "vesselSpeed.model", "seaSurfaceTemperature.model", "comment2.text", "vesselActivity.selectedItem", "previousFpaZone.selectedItem", "currentFpaZone.selectedItem", "nextFpaZone.selectedItem", "surroundingActivity.selectedItem", "close.enabled", "closeAndCreate.enabled");
        model.setModified(create);
    }

    @Override
    protected boolean doSave(Activity bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Activity> binder) throws Exception {
        boolean sexagecimalFormat = bean.isUseSexagecimalFormat();
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(false);
        }
        bean.storeCoordonnees();
        if (log.isDebugEnabled()) {
            log.debug((Object)("           long  - lat = " + bean.getLongitude() + " - " + bean.getLatitude()));
            log.debug((Object)("quadrant - along - alat = " + bean.getQuadrant() + " - " + bean.getAbsoluteLongitude() + " - " + bean.getAbsoluteLatitude()));
        }
        boolean create = bean.getTopiaId() == null;
        String routeId = this.getSelectedParentId();
        bean.setOpen(true);
        if (create) {
            bean = (Activity)dataService.create(dataSource, routeId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, routeId, (TopiaEntity)bean, this.getUpdateExecutor());
        }
        if (sexagecimalFormat) {
            bean.setUseSexagecimalFormat(true);
        }
        this.obtainChildPosition(bean, dataService, dataSource);
        return true;
    }

    @Override
    protected Activity onCreate(TopiaContext tx, Object parent, Activity editBean) throws TopiaException {
        Route parentBean = (Route)parent;
        Activity beanToSave = (Activity)ObserveDAOHelper.getActivityDAO((TopiaContext)tx).create(new Object[0]);
        editBean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addActivity(beanToSave);
        return beanToSave;
    }

    @Override
    protected Activity onUpdate(TopiaContext tx, Object parentBean, Activity beanToSave) throws TopiaException {
        Activity editBean = (Activity)this.getBean();
        Route route = (Route)parentBean;
        Date d = DBHelper.getDateAndTime((Date)route.getDate(), (Date)editBean.getTime());
        editBean.setTime(d);
        if (log.isInfoEnabled()) {
            log.info((Object)("Final time to use : " + d));
        }
        this.getLoadBinder().copyExcluding((Object)editBean, (Object)beanToSave, new String[]{"floatingObject", "observedSystem"});
        if (log.isInfoEnabled()) {
            log.info((Object)("Is activity open ? : " + beanToSave.isOpen()));
        }
        return beanToSave;
    }

    @Override
    protected boolean doDelete(Activity bean, DataService dataService, DataSource dataSource, TopiaExecutor2<? extends TopiaEntity, Activity> deletor) throws Exception {
        if (this.askToDelete(bean)) {
            return false;
        }
        String routeId = this.getSelectedParentId();
        dataService.delete(dataSource, routeId, (TopiaEntity)bean, deletor);
        return true;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, Activity beanToDelete) {
        Route parentBean = (Route)parent;
        parentBean.removeActivity(beanToDelete);
    }

    @Override
    protected boolean obtainCanReopen(boolean create) {
        DataContext dataContext = this.getDataContext();
        boolean canReopen = !create && dataContext.isSelectedOpen(Route.class) && !dataContext.isOpenActivity();
        return canReopen;
    }

    public String getActivity6Label() {
        try {
            List activitys = this.getDataService().getList(this.getDataSource(), VesselActivity.class);
            for (VesselActivity a : activitys) {
                if (!"6".equals(a.getCode())) continue;
                String label = this.getDecoratorService().decorate((Object)a);
                return label;
            }
        }
        catch (DataSourceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        throw new IllegalStateException(I18n.t((String)"observe.error.no.activity.6", (Object[])new Object[0]));
    }
}

