/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.seine;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.constants.seine.SchoolType;
import fr.ird.observe.entities.referentiel.seine.ObservedSystem;
import fr.ird.observe.entities.seine.Activity;
import fr.ird.observe.entities.seine.Set;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.seine.ObservedSystemUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.util.beans.BinderModelBuilder;

public class ObservedSystemUIHandler
extends ContentUIHandler<Activity> {
    private static Log log = LogFactory.getLog(ObservedSystemUIHandler.class);

    public ObservedSystemUIHandler(ObservedSystemUI ui) {
        super(ui, DataContextType.Activity, null);
    }

    public ObservedSystemUI getUi() {
        return (ObservedSystemUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<Activity> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Activity.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Activity.class, new String[]{"observedSystem", "set", "comment", "observedSystemDistance"});
            r = binderService.registerTopiaBinder(Activity.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(Activity.class)) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.t((String)"observe.message.activity.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        String activityId = this.getSelectedParentId();
        if (log.isInfoEnabled()) {
            log.info((Object)("activityId = " + activityId));
        }
        ContentMode mode = this.computeContentMode();
        this.getDataService().loadEditEntity(this.getDataSource(), activityId, this.getLoadExecutor());
        this.getModel().setMode(mode);
        if (mode == ContentMode.UPDATE) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        this.addInfoMessage(I18n.t((String)"observe.message.updating.activity", (Object[])new Object[0]));
        super.startEditUI(binding);
    }

    @Override
    protected boolean doSave(Activity bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Activity> binder) throws Exception {
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected Activity onUpdate(TopiaContext tx, Object parentBean, Activity beanToSave) throws TopiaException {
        Activity bean = (Activity)this.getBean();
        boolean needUpdateSet = false;
        SchoolType newTypeBanc = bean.getSchoolType();
        Set set = bean.getSet();
        if (set != null) {
            SchoolType oldTypeBanc = set.getSchoolType();
            needUpdateSet = oldTypeBanc == null || newTypeBanc != oldTypeBanc;
        }
        this.getLoadBinder().copyExcluding(this.getBean(), (Object)beanToSave, new String[]{"set"});
        if (needUpdateSet) {
            beanToSave.getSet().setSchoolType(newTypeBanc);
        }
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        super.afterSave(refresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectObservedSystem(Activity bean, Object[] selected) {
        boolean update;
        if (!this.getModel().isEditing()) {
            return;
        }
        boolean bl = update = selected.length != bean.sizeObservedSystem();
        if (!update && selected.length > 0) {
            List list = bean.getObservedSystem();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = this.getUi().getObservedSystem().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            try {
                ArrayList<ObservedSystem> newList = new ArrayList<ObservedSystem>(selected.length);
                for (Object o : selected) {
                    newList.add((ObservedSystem)o);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("update objectOperations " + newList.size()));
                }
                bean.setObservedSystem(newList);
            }
            finally {
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    protected int[] updateIndices(List<ObservedSystem> list) {
        int i;
        if (log.isInfoEnabled()) {
            log.info((Object)(list == null ? 0 : list.size()));
        }
        List ids = list == null ? Collections.emptyList() : TopiaEntityHelper.getTopiaIdList(list);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (list != null && !list.isEmpty()) {
            ListModel model = this.getUi().getObservedSystem().getModel();
            int max = model.getSize();
            for (i = 0; i < max; ++i) {
                ObservedSystem s = (ObservedSystem)model.getElementAt(i);
                if (!ids.contains(s.getTopiaId())) continue;
                indices.add(i);
            }
        }
        int[] result = new int[indices.size()];
        i = 0;
        for (Integer indice : indices) {
            result[i++] = indice;
        }
        indices.clear();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Selected indices : " + Arrays.toString(result)));
        }
        return result;
    }
}

