/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.seine;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.referentiel.Ocean;
import fr.ird.observe.entities.referentiel.ReferenceEntities;
import fr.ird.observe.entities.referentiel.Species;
import fr.ird.observe.entities.referentiel.Species2;
import fr.ird.observe.entities.seine.SchoolEstimate;
import fr.ird.observe.entities.seine.Set;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.seine.SchoolEstimateUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SchoolEstimateUIHandler
extends ContentTableUIHandler<Set, SchoolEstimate> {
    private static Log log = LogFactory.getLog(SchoolEstimateUIHandler.class);
    JAXXContextEntryDef<List<Species>> ALL_ESPECES_ENTRY = UIHelper.newListContextEntryDef((String)"SchoolEstimateUI-all-speciess");

    public static ContentTableUIModel<Set, SchoolEstimate> newModel(SchoolEstimateUI ui) {
        return new ContentTableUIModel<Set, SchoolEstimate>(Set.class, SchoolEstimate.class, new String[]{"schoolEstimate", "comment"}, new String[]{"set", "species", "totalWeight", "meanWeight"}, ui, ContentTableModel.newTableMeta(SchoolEstimate.class, "species", false), ContentTableModel.newTableMeta(SchoolEstimate.class, "totalWeight", false), ContentTableModel.newTableMeta(SchoolEstimate.class, "meanWeight", false));
    }

    public SchoolEstimateUIHandler(SchoolEstimateUI ui) {
        super(ui);
    }

    @Override
    public SchoolEstimateUI getUi() {
        return (SchoolEstimateUI)super.getUi();
    }

    @Override
    protected Set loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        List speciesList;
        if (mode == ContentMode.UPDATE) {
            Ocean ocean = dataService.getTripOcean(dataSource, dataContext.getSelectedTripId());
            ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
            int speciesListId = config.getSpeciesListSeineSchoolEstimate();
            List allSpecies = dataService.loadDecoratedSpecies(dataSource, speciesListId);
            ReferenceEntities.filterReferentielListByStatus((List)allSpecies);
            speciesList = Species2.filterByOcean((Collection)allSpecies, (Ocean)ocean);
        } else {
            speciesList = new ArrayList();
        }
        this.ALL_ESPECES_ENTRY.setContextValue((JAXXContext)this.getUi(), speciesList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("speciesList = " + speciesList.size()));
        }
        return (Set)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, SchoolEstimate bean, boolean create) {
        BeanComboBox<Species> requestFocus;
        List<Object> availableEspeces;
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        SchoolEstimateUI ui = this.getUi();
        if (create) {
            availableEspeces = new ArrayList((Collection)this.ALL_ESPECES_ENTRY.getContextValue((JAXXContext)ui));
            List list = model.getColumnValues(0);
            availableEspeces.removeAll(list);
            list.clear();
            requestFocus = ui.getSpecies();
        } else {
            Species species = bean.getSpecies();
            availableEspeces = Arrays.asList(species);
            requestFocus = ui.getTotalWeight();
        }
        ui.getSpecies().setData(availableEspeces);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.table.schoolEstimate.speciesThon", (Object[])new Object[0]), I18n.n((String)"observe.table.schoolEstimate.speciesThon.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.schoolEstimate.weight", (Object[])new Object[0]), I18n.n((String)"observe.table.schoolEstimate.weight.tip", (Object[])new Object[0]), I18n.n((String)"observe.table.schoolEstimate.meanWeight", (Object[])new Object[0]), I18n.n((String)"observe.table.schoolEstimate.meanWeight.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Species.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected boolean prepareSave(Set editBean, List<SchoolEstimate> objets) {
        for (SchoolEstimate schoolEstimate : objets) {
            schoolEstimate.setSet(editBean);
        }
        return true;
    }
}

