/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.entities.longline.WeightMeasure;
import fr.ird.observe.entities.longline.WeightMeasureImpl;
import fr.ird.observe.entities.referentiel.longline.WeightMeasureType;
import fr.ird.observe.ui.util.table.EditableTableWithCacheTableModelSupport;

public class WeightMeasuresTableModel
extends EditableTableWithCacheTableModelSupport<WeightMeasure> {
    private static final long serialVersionUID = 1L;

    public WeightMeasuresTableModel() {
        super(ObserveServiceHelper.get().getBinderService().getSimpleTopiaBinder(WeightMeasure.class));
    }

    @Override
    public boolean isRowNotEmpty(WeightMeasure valid) {
        return valid.getWeightMeasureType() != null || valid.getWeight() != null;
    }

    @Override
    public boolean isRowValid(WeightMeasure valid) {
        Float weight = valid.getWeight();
        return valid.getWeightMeasureType() != null && weight != null && weight.floatValue() > 0.0f && weight.floatValue() < 1000.0f;
    }

    @Override
    protected WeightMeasure createNewRow() {
        return new WeightMeasureImpl();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        WeightMeasure measure = (WeightMeasure)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                result = measure.getWeightMeasureType();
                break;
            }
            case 1: {
                result = measure.getWeight();
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        WeightMeasure measure = (WeightMeasure)this.data.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                measure.setWeightMeasureType((WeightMeasureType)aValue);
                break;
            }
            case 1: {
                measure.setWeight((Float)aValue);
                break;
            }
            default: {
                throw new IllegalStateException("Can't come here");
            }
        }
        this.setModified(true);
    }
}

