/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.util.table;

import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.util.table.MoveToNextEditableCellAction;
import fr.ird.observe.ui.util.table.MoveToNextEditableRowAction;
import fr.ird.observe.ui.util.table.MoveToPreviousEditableCellAction;
import fr.ird.observe.ui.util.table.MoveToPreviousEditableRowAction;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.autocomplete.ComboBoxCellEditor;

public abstract class EditableTableModelSupport<E extends Serializable>
extends AbstractTableModel {
    private static final Log log = LogFactory.getLog(EditableTableModelSupport.class);
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String EMPTY_PROPERTY = "empty";
    public static final String MODIFIED_PROPERTY = "modified";
    public static final String VALID_PROPERTY = "valid";
    public static final String SELECTED_ROW_INDEX_PROPERTY = "selectedRowIndex";
    public static final String SELECTED_ROW_PROPERTY = "selectedRow";
    public static final String SELECTION_EMPTY_PROPERTY = "selectionEmpty";
    private static final long serialVersionUID = 1L;
    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected boolean editable;
    protected boolean valid;
    protected boolean modified;
    protected int selectedRowIndex = -1;
    protected List<E> data = new ArrayList();
    private JTable table;
    private transient ListSelectionModel selectionModel;
    private final boolean canAddRow;
    protected transient ListSelectionListener whenSelectionModelChanged;
    private boolean selectionIsAdjusting;
    private static final String OBSERVE_KEY_ADAPTER = "ObServeKeyAdapter";
    private static final String OBSERVE_FOCUS_ADAPTER = "ObServeFocusAdapter";

    protected EditableTableModelSupport(boolean canAddRow) {
        this.canAddRow = canAddRow;
    }

    public boolean isCanAddRow() {
        return this.canAddRow;
    }

    protected abstract E createNewRow();

    public abstract boolean isRowNotEmpty(E var1);

    protected abstract boolean isRowValid(E var1);

    protected boolean isCanCreateNewRow(int rowIndex) {
        boolean canCreateNewRow = this.canAddRow;
        if (this.canAddRow) {
            E row = this.getData(rowIndex);
            canCreateNewRow = this.isRowNotEmpty(row) && this.isRowValid(row);
        }
        return canCreateNewRow;
    }

    public List<E> getNotEmptyData() {
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        for (Serializable row : this.data) {
            if (!this.isRowNotEmpty(row)) continue;
            result.add(row);
        }
        return result;
    }

    public List<E> getData() {
        return this.data;
    }

    public E getData(int rowIndex) {
        return (E)((Serializable)this.data.get(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public void setData(List<E> data) {
        this.data.clear();
        this.data.addAll(data);
        if (this.data.isEmpty() && this.editable && this.canAddRow) {
            this.addNewRow(0, false);
        }
        this.selectedRowIndex = -1;
        this.fireTableDataChanged();
        this.setSelectedRowIndex(this.isEmpty() ? -1 : 0, true);
    }

    public void removeData(int selectedRow) {
        this.data.remove(selectedRow);
        this.fireTableRowsDeleted(selectedRow, selectedRow);
        this.setSelectedRowIndex(this.isEmpty() ? -1 : selectedRow - 1, true);
    }

    public void removeSelectedRow() {
        int selectedRowIndex1 = this.getSelectedRowIndex();
        this.setSelectedRowIndex(-1, true);
        this.removeData(selectedRowIndex1);
    }

    public void addNewRow() {
        int row = this.getRowCount();
        this.addNewRow(row, true);
    }

    public void insertBeforeSelectedRow() {
        int currentRow = this.getSelectedRowIndex();
        int insertRow = currentRow;
        if (insertRow < 0) {
            insertRow = 0;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Insert before selected row: " + currentRow + " :: " + insertRow));
        }
        this.addNewRow(insertRow, true);
    }

    public void insertAfterSelectedRow() {
        int insertRow;
        int currentRow = this.getSelectedRowIndex();
        int n = insertRow = currentRow == this.getRowCount() ? currentRow : currentRow + 1;
        if (log.isInfoEnabled()) {
            log.info((Object)("Insert after selected row: " + currentRow + " :: " + insertRow));
        }
        this.addNewRow(insertRow, true);
    }

    public void addNewRow(int row, boolean fireAndSelectNewRow) {
        this.ensureEditable();
        E bean = this.createNewRow();
        if (row == this.getRowCount()) {
            this.data.add(bean);
        } else {
            this.data.add(row, bean);
        }
        if (fireAndSelectNewRow) {
            this.fireTableRowsInserted(row, row);
            this.fireEmpty();
            this.setSelectedRowIndex(row, true);
        }
    }

    public void clear() {
        this.setSelectedRowIndex(-1);
        this.setData(Collections.emptyList());
        this.validate();
        this.setModified(false);
        this.fireEmpty();
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public boolean isSelectionEmpty() {
        return this.getSelectedRowIndex() == -1;
    }

    public E getSelectedRow() {
        return this.isSelectionEmpty() ? null : (E)this.getData(this.getSelectedRowIndex());
    }

    public int getSelectedRowIndex() {
        return this.selectedRowIndex;
    }

    public void setSelectedRowIndex(int selectedRowIndex) {
        this.setSelectedRowIndex(selectedRowIndex, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRowIndex(int selectedRowIndex, boolean pushToSelectionModel) {
        if (!this.selectionIsAdjusting) {
            this.selectionIsAdjusting = true;
            try {
                int oldSelectedRowIndex = this.getSelectedRowIndex();
                E oldSelectedRow = this.getSelectedRow();
                this.selectedRowIndex = selectedRowIndex;
                if (pushToSelectionModel && this.getSelectionModel() != null) {
                    this.getSelectionModel().setSelectionInterval(selectedRowIndex, selectedRowIndex);
                }
                this.firePropertyChange(SELECTED_ROW_INDEX_PROPERTY, oldSelectedRowIndex, selectedRowIndex);
                this.firePropertyChange(SELECTION_EMPTY_PROPERTY, null, this.isSelectionEmpty());
                this.firePropertyChange(SELECTED_ROW_PROPERTY, oldSelectedRow, this.getSelectedRow());
            }
            finally {
                this.selectionIsAdjusting = false;
            }
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.firePropertyChange(MODIFIED_PROPERTY, null, modified);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void fireEmpty() {
        this.firePropertyChange(EMPTY_PROPERTY, null, this.isEmpty());
    }

    protected void ensureEditable() throws IllegalStateException {
        if (!this.editable) {
            throw new IllegalStateException("can not edit this model since it is marked as none editable " + this);
        }
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        this.firePropertyChange(VALID_PROPERTY, null, this.isValid());
    }

    public void validate() {
        boolean newValidValue = this.computeValidState();
        this.setValid(newValidValue);
    }

    protected boolean computeValidState() {
        boolean newValidValue = true;
        for (Serializable row : this.data) {
            boolean rowValid = !this.isRowNotEmpty(row) || this.isRowValid(row);
            if (rowValid) continue;
            newValidValue = false;
            break;
        }
        return newValidValue;
    }

    public void installSelectionListener(JTable table) {
        this.uninstallSelectionListener(table);
        this.table = table;
        ListSelectionListener listener = this.getWhenSelectionModelChanged();
        this.getSelectionModel().addListSelectionListener(listener);
    }

    public ListSelectionModel getSelectionModel() {
        if (this.selectionModel == null) {
            this.selectionModel = this.table == null ? null : this.table.getSelectionModel();
        }
        return this.selectionModel;
    }

    public void uninstallSelectionListener(JTable table) {
        ListSelectionListener listener = this.getWhenSelectionModelChanged();
        table.getSelectionModel().removeListSelectionListener(listener);
        this.table = null;
        this.selectionModel = null;
    }

    public void installTableFocusListener(final JTable table) {
        this.uninstallTableFocusListener(table);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                UIHelper.stopEditing(table);
            }
        };
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            NumberCellEditor editor;
            TableColumn tableColumn = columns.nextElement();
            TableCellEditor cellEditor = tableColumn.getCellEditor();
            if (cellEditor instanceof NumberCellEditor) {
                editor = (NumberCellEditor)cellEditor;
                editor.getNumberEditor().getTextField().addFocusListener(focusAdapter);
                continue;
            }
            if (!(cellEditor instanceof ComboBoxCellEditor)) continue;
            editor = (ComboBoxCellEditor)cellEditor;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Intall " + focusAdapter));
        }
        table.putClientProperty(OBSERVE_FOCUS_ADAPTER, focusAdapter);
    }

    public void uninstallTableFocusListener(JTable table) {
        FocusAdapter focusAdapter = (FocusAdapter)table.getClientProperty(OBSERVE_FOCUS_ADAPTER);
        if (focusAdapter != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Desintall " + focusAdapter));
            }
            TableColumnModel columnModel = table.getColumnModel();
            Enumeration<TableColumn> columns = columnModel.getColumns();
            while (columns.hasMoreElements()) {
                TableColumn tableColumn = columns.nextElement();
                TableCellEditor cellEditor = tableColumn.getCellEditor();
                if (!(cellEditor instanceof NumberCellEditor)) continue;
                NumberCellEditor editor = (NumberCellEditor)cellEditor;
                editor.getNumberEditor().getTextField().removeFocusListener(focusAdapter);
            }
            table.putClientProperty(OBSERVE_KEY_ADAPTER, null);
        }
    }

    public void installTableKeyListener(final JTable table) {
        this.uninstallTableKeyListener(table);
        EditableTableModelSupport model = (EditableTableModelSupport)table.getModel();
        final MoveToNextEditableCellAction<EditableTableModelSupport> nextCellAction = MoveToNextEditableCellAction.newAction(model, table);
        final MoveToPreviousEditableCellAction<EditableTableModelSupport> previousCellAction = MoveToPreviousEditableCellAction.newAction(model, table);
        final MoveToNextEditableRowAction<EditableTableModelSupport> nextRowAction = MoveToNextEditableRowAction.newAction(model, table);
        final MoveToPreviousEditableRowAction<EditableTableModelSupport> previousRowAction = MoveToPreviousEditableRowAction.newAction(model, table);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TableCellEditor editor = table.getCellEditor();
                int keyCode = e.getKeyCode();
                if (keyCode == 37 || keyCode == 9 && e.isShiftDown()) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    previousCellAction.actionPerformed(null);
                } else if (keyCode == 39 || keyCode == 9) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    nextCellAction.actionPerformed(null);
                } else if (keyCode == 38 || keyCode == 10 && e.isShiftDown()) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    previousRowAction.actionPerformed(null);
                } else if (e.getKeyCode() == 10 || keyCode == 40) {
                    e.consume();
                    if (editor != null) {
                        editor.stopCellEditing();
                    }
                    nextRowAction.actionPerformed(null);
                }
            }
        };
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = columns.nextElement();
            TableCellEditor cellEditor = tableColumn.getCellEditor();
            if (!(cellEditor instanceof NumberCellEditor)) continue;
            NumberCellEditor editor = (NumberCellEditor)cellEditor;
            editor.getNumberEditor().getTextField().addKeyListener(keyAdapter);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Intall " + keyAdapter));
        }
        table.addKeyListener(keyAdapter);
        table.putClientProperty(OBSERVE_KEY_ADAPTER, keyAdapter);
    }

    public void uninstallTableKeyListener(JTable table) {
        KeyAdapter keyAdapter = (KeyAdapter)table.getClientProperty(OBSERVE_KEY_ADAPTER);
        if (keyAdapter != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Desintall " + keyAdapter));
            }
            table.removeKeyListener(keyAdapter);
            TableColumnModel columnModel = table.getColumnModel();
            Enumeration<TableColumn> columns = columnModel.getColumns();
            while (columns.hasMoreElements()) {
                TableColumn tableColumn = columns.nextElement();
                TableCellEditor cellEditor = tableColumn.getCellEditor();
                if (!(cellEditor instanceof NumberCellEditor)) continue;
                NumberCellEditor editor = (NumberCellEditor)cellEditor;
                editor.getNumberEditor().getTextField().removeKeyListener(keyAdapter);
            }
            table.putClientProperty(OBSERVE_KEY_ADAPTER, null);
        }
    }

    protected ListSelectionListener getWhenSelectionModelChanged() {
        if (this.whenSelectionModelChanged == null) {
            this.whenSelectionModelChanged = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = EditableTableModelSupport.this.table.getSelectedRow();
                        if (selectedRow >= EditableTableModelSupport.this.getRowCount()) {
                            selectedRow = EditableTableModelSupport.this.getRowCount() - 1;
                            if (log.isInfoEnabled()) {
                                log.info((Object)("Decrease selectedRow!!! to " + selectedRow));
                            }
                        }
                        EditableTableModelSupport.this.setSelectedRowIndex(selectedRow);
                    }
                }
            };
        }
        return this.whenSelectionModelChanged;
    }
}

