/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import fr.ird.observe.DataService;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.Basket;
import fr.ird.observe.entities.longline.Baskets;
import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.entities.longline.Branchlines;
import fr.ird.observe.entities.longline.Section;
import fr.ird.observe.entities.longline.SetLongline;
import fr.ird.observe.entities.longline.Tdr;
import fr.ird.observe.entities.referentiel.longline.SensorBrand;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.longline.TdrUI;
import fr.ird.observe.ui.content.table.impl.longline.TdrUIModel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.serial.SerialBlob;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.runtime.JaxxFileChooser;
import org.nuiton.topia.persistence.TopiaId;
import org.nuiton.validator.NuitonValidatorScope;

public class TdrUIHandler
extends ContentTableUIHandler<SetLongline, Tdr> {
    private static Log log = LogFactory.getLog(TdrUIHandler.class);
    protected boolean locationIsAdjusting;
    JAXXContextEntryDef<List<Section>> ALL_SECTIONS_ENTRY = UIHelper.newListContextEntryDef((String)"TdrUI-all-sections");
    JAXXContextEntryDef<Map<String, Section>> ALL_SECTIONS_BY_ID_ENTRY = UIHelper.newMapContextEntryDef((String)"TdrUI-all-sections-by-id");
    JAXXContextEntryDef<List<Basket>> ALL_BASKETS_ENTRY = UIHelper.newListContextEntryDef((String)"TdrUI-all-baskets");
    JAXXContextEntryDef<Map<String, Basket>> ALL_BASKETS_BY_ID_ENTRY = UIHelper.newMapContextEntryDef((String)"TdrUI-all-baskets-by-id");
    JAXXContextEntryDef<List<Branchline>> ALL_BRANCHLINES_ENTRY = UIHelper.newListContextEntryDef((String)"TdrUI-all-branchlines");
    JAXXContextEntryDef<Map<String, Branchline>> ALL_BRANCHLINES_BY_ID_ENTRY = UIHelper.newMapContextEntryDef((String)"TdrUI-all-branchlines-by-id");
    private final PropertyChangeListener sectionChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TdrUIHandler.this.onSectionChanged((Section)evt.getNewValue(), (Tdr)evt.getSource());
        }
    };
    private final PropertyChangeListener basketChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TdrUIHandler.this.onBasketChanged((Basket)evt.getNewValue(), (Tdr)evt.getSource());
        }
    };
    protected final TableModelListener computeTabValidStateListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            SwingValidatorMessageTableModel source = (SwingValidatorMessageTableModel)e.getSource();
            TdrUIHandler.this.computeTabValidState(source);
        }
    };

    public TdrUIHandler(TdrUI ui) {
        super(ui, DataContextType.SetLongline);
    }

    @Override
    public TdrUI getUi() {
        return (TdrUI)super.getUi();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, Tdr bean, boolean create) {
        ContentTableModel model = this.getTableModel();
        if (!model.isEditable()) {
            return;
        }
        String homeId = bean.getHomeId();
        TdrUI ui = this.getUi();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected tdr " + homeId));
        }
        JTextField requestFocus = ui.getHomeId();
        Tdr tableEditBean = (Tdr)this.getTableEditBean();
        tableEditBean.removePropertyChangeListener("section", this.sectionChanged);
        tableEditBean.addPropertyChangeListener("section", this.sectionChanged);
        tableEditBean.removePropertyChangeListener("basket", this.basketChanged);
        tableEditBean.addPropertyChangeListener("basket", this.basketChanged);
        if (create) {
            SetLongline setLongline = (SetLongline)this.getBean();
            Date settingStartTimeStamp = setLongline.getSettingStartTimeStamp();
            tableEditBean.setDeployementStart(settingStartTimeStamp);
            tableEditBean.setDeployementEnd(settingStartTimeStamp);
            tableEditBean.setFishingStart(settingStartTimeStamp);
            tableEditBean.setFishingEnd(settingStartTimeStamp);
            ui.getEditTabPane().setSelectedIndex(0);
        }
        this.resetLocation(tableEditBean);
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.tdr.table.homeId", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.homeId.tip", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.serialNo", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.serialNo.tip", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.sensorBrand", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.sensorBrand.tip", (Object[])new Object[0]), I18n.n((String)"observe.tdr.table.data", (Object[])new Object[0]), I18n.n((String)"observe.sensorUsed.table.data.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, SensorBrand.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer, (Predicate)new Predicate<Object>(){

            public boolean apply(Object input) {
                return input != null;
            }
        }));
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedSetId();
    }

    @Override
    public void initUI() throws Exception {
        ObserveConfig config = this.getUi().getContextValue(ObserveConfig.class);
        String speciesListId = config.getSpeciesListLonglineCatch();
        this.prepareSpeciesList(speciesListId, (JComponent)this.getUi().getSpecies());
        super.initUI();
    }

    @Override
    public void openUI() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("OpenUI: " + (Object)((Object)this.getModel())));
        }
        super.openUI();
        this.getUi().getSection().setData((List)this.ALL_SECTIONS_ENTRY.getContextValue((JAXXContext)this.getUi()));
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
        this.getUi().getErrorTableModel().addTableModelListener(this.computeTabValidStateListener);
        SwingValidatorMessageTableModel errorTableModel = this.getUi().getErrorTableModel();
        this.computeTabValidState(errorTableModel);
    }

    @Override
    protected void closeSafeUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("CloseUI: " + (Object)((Object)this.getModel())));
        }
        super.closeSafeUI();
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
    }

    @Override
    protected SetLongline loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        SetLongline setLongline = (SetLongline)super.loadEditBean(mode, dataContext, dataService, dataSource);
        List sections = dataService.getSections(dataSource, setLongline.getTopiaId());
        this.ALL_SECTIONS_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)sections);
        this.ALL_SECTIONS_BY_ID_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)Maps.uniqueIndex((Iterable)sections, (Function)TopiaId.GET_TOPIA_ID));
        List baskets = Baskets.getBaskets((List)sections);
        this.ALL_BASKETS_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)baskets);
        this.ALL_BASKETS_BY_ID_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)Maps.uniqueIndex((Iterable)baskets, (Function)TopiaId.GET_TOPIA_ID));
        List branchlines = Branchlines.getBranchlines((List)baskets);
        this.ALL_BRANCHLINES_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)branchlines);
        this.ALL_BRANCHLINES_BY_ID_ENTRY.setContextValue((JAXXContext)this.getUi(), (Object)Maps.uniqueIndex((Iterable)branchlines, (Function)TopiaId.GET_TOPIA_ID));
        return setLongline;
    }

    public void importData() {
        File file = UIHelper.chooseFile((Component)((Object)this.ui), I18n.t((String)"observe.title.choose.tdr.importData", (Object[])new Object[0]), I18n.t((String)"observe.action.choose.tdr.importData", (Object[])new Object[0]), null, new String[0]);
        if (file != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Set data from file: " + file));
            }
            try {
                byte[] fileContent = FileUtils.readFileToByteArray((File)file);
                SerialBlob serialBlob = new SerialBlob(fileContent);
                ((Tdr)this.getTableEditBean()).setData((Blob)serialBlob);
                ((Tdr)this.getTableEditBean()).setDataFilename(file.getName());
                ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
                mainUI.getStatus().setStatus(I18n.t((String)"observe.tdr.message.data.imported", (Object[])new Object[]{file}));
            }
            catch (IOException e) {
                throw new ObserveTechnicalException("Could not read file: " + file, (Throwable)e);
            }
            catch (SQLException e) {
                throw new ObserveTechnicalException("Could not create binary data from file: " + file, (Throwable)e);
            }
        }
    }

    public void deleteData() {
        boolean doDelete;
        int response = UIHelper.askUser((Component)((Object)this.ui), I18n.t((String)"observe.title.delete", (Object[])new Object[0]), I18n.t((String)"observe.tdr.delete.data.message", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.confirm.delete", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 1);
        boolean bl = doDelete = response == 0;
        if (doDelete) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete tdr data " + ((Tdr)this.getTableEditBean()).getData()));
            }
            ((Tdr)this.getTableEditBean()).setData(null);
            ((Tdr)this.getTableEditBean()).setDataFilename(null);
        }
    }

    public void exportData() {
        String filename;
        try {
            filename = this.getDataService().getTdrDataFilename(this.getDataSource(), (Tdr)this.getTableEditBean());
        }
        catch (DataSourceException e) {
            throw new ObserveTechnicalException("Could not obtain tdr data export filename", (Throwable)e);
        }
        File file = JaxxFileChooser.forSaving().setParent((Component)((Object)this.getUi())).setTitle(I18n.t((String)"observe.title.choose.tdr.exportData", (Object[])new Object[0])).setApprovalText(I18n.t((String)"observe.action.choose.tdr.exportData", (Object[])new Object[0])).setFilename(filename).setUseAcceptAllFileFilter(true).choose();
        if (file != null) {
            InputStream binaryStream;
            if (log.isInfoEnabled()) {
                log.info((Object)("save tdr data to " + file));
            }
            try {
                binaryStream = ((Tdr)this.getTableEditBean()).getData().getBinaryStream();
            }
            catch (SQLException e) {
                throw new ObserveTechnicalException("Could not read binary data", (Throwable)e);
            }
            OutputStream outputstream = null;
            try {
                outputstream = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).openBufferedStream();
                IOUtils.copy((InputStream)binaryStream, (OutputStream)outputstream);
                outputstream.close();
                ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
                mainUI.getStatus().setStatus(I18n.t((String)"observe.sensorUsed.message.data.exported", (Object[])new Object[]{file}));
            }
            catch (IOException e) {
                try {
                    throw new ObserveTechnicalException("Could not save binary data to " + file, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputstream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)outputstream);
        }
    }

    protected void computeTabValidState(SwingValidatorMessageTableModel errorTableModel) {
        HashSet<String> errorProperties = new HashSet<String>();
        int rowCount = errorTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            SwingValidatorMessage row = errorTableModel.getRow(i);
            if (!NuitonValidatorScope.ERROR.equals((Object)row.getScope())) continue;
            errorProperties.add(row.getField());
        }
        boolean caracteristicsTabValid = !errorProperties.removeAll(TdrUIModel.CARACTERISTIC_TAB_PROPERTIES);
        boolean timestampTabValid = !errorProperties.removeAll(TdrUIModel.TIMESTAMP_TAB_PROPERTIES);
        boolean keyDataTabValid = !errorProperties.removeAll(TdrUIModel.KEY_DATA_TAB_PROPERTIES);
        boolean speciesTabValid = !errorProperties.removeAll(TdrUIModel.SPECIES_TAB_PROPERTIES);
        TdrUIModel model = (TdrUIModel)this.getModel();
        model.setCaracteristicsTabValid(caracteristicsTabValid);
        model.setTimestampTabValid(timestampTabValid);
        model.setKeyDataTabValid(keyDataTabValid);
        model.setSpeciesTabValid(speciesTabValid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSectionChanged(Section newValue, Tdr tableEditBean) {
        this.locationIsAdjusting = true;
        try {
            TdrUI ui = this.getUi();
            Basket basket = tableEditBean.getBasket();
            Branchline branchline = tableEditBean.getBranchline();
            tableEditBean.setBasket(null);
            tableEditBean.setBranchline(null);
            if (newValue == null) {
                ui.getBasket().setData((List)this.ALL_BASKETS_ENTRY.getContextValue((JAXXContext)ui));
                List branchlines = basket != null ? basket.getBranchline() : (List)this.ALL_BRANCHLINES_ENTRY.getContextValue((JAXXContext)ui);
                ui.getBranchline().setData(branchlines);
            } else {
                List baskets = newValue.getBasket();
                ui.getBasket().setData(baskets);
                List branchlines = basket != null ? basket.getBranchline() : Branchlines.getBranchlines((List)baskets);
                ui.getBranchline().setData(branchlines);
            }
            if (basket != null) {
                tableEditBean.setBasket(basket);
            }
            if (branchline != null) {
                tableEditBean.setBranchline(branchline);
            }
        }
        finally {
            this.locationIsAdjusting = false;
        }
    }

    protected void onBasketChanged(Basket newValue, Tdr tableEditBean) {
        if (!this.locationIsAdjusting) {
            TdrUI ui = this.getUi();
            Branchline branchline = tableEditBean.getBranchline();
            tableEditBean.setBranchline(null);
            if (newValue == null) {
                Section section = tableEditBean.getSection();
                List branchlines = section == null ? (List)this.ALL_BRANCHLINES_ENTRY.getContextValue((JAXXContext)ui) : Branchlines.getBranchlines((List)section.getBasket());
                ui.getBranchline().setData(branchlines);
            } else {
                List branchlines = newValue.getBranchline();
                ui.getBranchline().setData(branchlines);
            }
            if (branchline != null) {
                tableEditBean.setBranchline(branchline);
            }
        }
    }

    protected void resetLocation(Tdr tableEditBean) {
    }
}

